/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.oai;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import java.sql.SQLException;
import java.util.Properties;
import org.dspace.app.util.Util;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.search.HarvestedItemInfo;

public class RDFCrosswalk
extends Crosswalk {
    private String baseUrl = ConfigurationManager.getProperty((String)"dspace.url");
    private String hostName = ConfigurationManager.getProperty((String)"dspace.hostname");

    public RDFCrosswalk(Properties properties) {
        super("http://www.openarchives.org/OAI/2.0/rdf/ http://www.openarchives.org/OAI/2.0/rdf.xsd");
    }

    public boolean isAvailableFor(Object nativeItem) {
        return nativeItem instanceof HarvestedItemInfo;
    }

    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        HarvestedItemInfo itemInfo = (HarvestedItemInfo)nativeItem;
        Item item = itemInfo.item;
        DCValue[] allDC = item.getDC("*", "*", "*");
        StringBuffer metadata = new StringBuffer();
        metadata.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" ").append("xmlns:ow=\"http://www.ontoweb.org/ontology/1#\" ").append("xmlns:dc=\"http://purl.org/dc/elements/1.1/\" ").append("xmlns:ds=\"http://dspace.org/ds/elements/1.1/\" ").append("xsi:schemaLocation=\"http://www.w3.org/1999/02/22-rdf-syntax-ns# http://www.openarchives.org/OAI/2.0/rdf.xsd\">");
        metadata.append("<ow:Publication rdf:about=\"oai:").append(this.hostName).append(":").append(item.getHandle()).append("\">");
        for (int i = 0; i < allDC.length; ++i) {
            if (!this.screened(allDC[i])) continue;
            String element = allDC[i].element;
            if (allDC[i].element.equals("contributor") && allDC[i].qualifier != null && allDC[i].qualifier.equals("author")) {
                element = "creator";
            }
            String value = allDC[i].value;
            int c = -1;
            while ((c = value.indexOf("&", c + 1)) > -1) {
                value = value.substring(0, c) + "&amp;" + value.substring(c + 1);
            }
            while ((c = value.indexOf("<")) > -1) {
                value = value.substring(0, c) + "&lt;" + value.substring(c + 1);
            }
            while ((c = value.indexOf(">")) > -1) {
                value = value.substring(0, c) + "&gt;" + value.substring(c + 1);
            }
            metadata.append("<dc:").append(element).append(">").append(value).append("</dc:").append(element).append(">");
        }
        Collection[] colls = null;
        Community[] comms = null;
        Bundle[] origBundles = null;
        Bundle[] thumbBundles = null;
        try {
            colls = item.getCollections();
            comms = item.getCommunities();
            origBundles = item.getBundles("ORIGINAL");
            thumbBundles = item.getBundles("THUMBNAIL");
        }
        catch (SQLException sqlE) {
            // empty catch block
        }
        for (int i = 0; i < comms.length; ++i) {
            metadata.append("<dc:source>").append(comms[i].getMetadata("name")).append("</dc:source>");
        }
        for (int j = 0; j < colls.length; ++j) {
            metadata.append("<dc:source>").append(colls[j].getMetadata("name")).append("</dc:source>");
        }
        if (origBundles.length > 0) {
            Bitstream[] bitstreams = origBundles[0].getBitstreams();
            for (int j = 0; j < bitstreams.length; ++j) {
                String tName = bitstreams[j].getName() + ".jpg";
                Bitstream tb = null;
                if (thumbBundles.length > 0) {
                    tb = thumbBundles[0].getBitstreamByName(tName);
                }
                if (tb == null) continue;
                String thumbUrl = null;
                try {
                    thumbUrl = this.baseUrl + "/retrieve/" + tb.getID() + "/" + Util.encodeBitstreamName((String)tb.getName(), (String)"UTF-8");
                }
                catch (Exception e) {
                    // empty catch block
                }
                metadata.append("<dc:coverage>").append(thumbUrl).append("</dc:coverage>");
            }
        }
        metadata.append("</ow:Publication>");
        metadata.append("</rdf:RDF>");
        return metadata.toString();
    }

    private boolean screened(DCValue dcValue) {
        if (this.isQualified(dcValue, "description", "provenance")) {
            return false;
        }
        if (this.isQualified(dcValue, "format", "extent")) {
            return false;
        }
        return !this.isQualified(dcValue, "date", "accessioned");
    }

    private boolean isQualified(DCValue dcValue, String elName, String qualName) {
        return dcValue.element.equals(elName) && dcValue.qualifier != null && dcValue.qualifier.equals(qualName);
    }
}

