/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager;

import java.util.Date;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.dspace.kernel.CommonLifecycle;
import org.dspace.kernel.DSpaceKernel;
import org.dspace.kernel.DSpaceKernelManager;
import org.dspace.kernel.ServiceManager;
import org.dspace.servicemanager.DSpaceServiceManager;
import org.dspace.servicemanager.ServiceManagerSystem;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.services.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DSpaceKernelImpl
implements DSpaceKernel,
DynamicMBean,
CommonLifecycle<DSpaceKernel> {
    private static Logger log = LoggerFactory.getLogger(DSpaceKernelImpl.class);
    private String mBeanName = "org.dspace:name=Kernel,type=DSpaceKernel";
    private boolean running = false;
    private boolean destroyed = false;
    private final Object lock = new Object();
    private DSpaceKernel kernel = null;
    private Thread shutdownHook;
    private ConfigurationService configurationService;
    private ServiceManagerSystem serviceManagerSystem;
    private Date lastLoadDate;
    private long loadTime;

    protected DSpaceKernelImpl(String name) {
        this.mBeanName = DSpaceKernelManager.checkName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerShutdownHook() {
        if (this.shutdownHook == null) {
            Object object = this.lock;
            synchronized (object) {
                this.shutdownHook = new Thread(){

                    @Override
                    public void run() {
                        DSpaceKernelImpl.this.doDestroy();
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
        }
    }

    @Override
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManagerSystem;
    }

    @Override
    public String getMBeanName() {
        return this.mBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSpaceKernel getManagedBean() {
        Object object = this.lock;
        synchronized (object) {
            return this.kernel;
        }
    }

    @Override
    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String dspaceHome) {
        if (this.running) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.lastLoadDate = new Date();
            long startTime = System.currentTimeMillis();
            DSpaceConfigurationService dsConfigService = new DSpaceConfigurationService(dspaceHome);
            this.configurationService = dsConfigService;
            this.serviceManagerSystem = new DSpaceServiceManager(dsConfigService);
            this.serviceManagerSystem.startup();
            this.loadTime = System.currentTimeMillis() - startTime;
            this.kernel = this;
            this.running = true;
            this.registerShutdownHook();
        }
        log.info("DSpace kernel startup completed in " + this.loadTime + " ms and registered as MBean: " + this.mBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.kernel = null;
            if (this.serviceManagerSystem != null) {
                this.serviceManagerSystem.shutdown();
            }
            this.serviceManagerSystem = null;
            this.configurationService = null;
        }
        log.info("DSpace kernel shutdown completed and unregistered MBean: " + this.mBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.stop();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (DSpaceKernelManager.getDefaultKernel() == this) {
                DSpaceKernelManager.setDefaultKernel(null);
            }
            try {
                DSpaceKernelManager.unregisterMBean(this.mBeanName);
            }
            finally {
                if (this.shutdownHook != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                        this.shutdownHook = null;
                    }
                    catch (Exception exception) {}
                }
            }
            this.destroyed = true;
        }
    }

    protected void doDestroy() {
        if (!this.destroyed) {
            this.destroy();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.doDestroy();
        }
        catch (Exception e) {
            log.error("WARN Failure attempting to cleanup the DSpace kernel: " + e.getMessage(), (Throwable)e);
        }
        super.finalize();
    }

    public String toString() {
        return "DSpaceKernel:" + this.mBeanName + ":lastLoad=" + this.lastLoadDate + ":loadTime=" + this.loadTime + ":running=" + this.running + ":kernel=" + (this.kernel == null ? null : this.kernel.getClass().getName() + "@" + this.kernel.getClass().getClassLoader() + ":" + super.toString());
    }

    public Date getLastLoadDate() {
        return new Date(this.lastLoadDate.getTime());
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return this;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        DescriptorSupport lastLoadDateDesc = new DescriptorSupport("name=LastLoadDate", "descriptorType=attribute", "default=0", "displayName=Last Load Date", "getMethod=getLastLoadDate");
        DescriptorSupport lastLoadTimeDesc = new DescriptorSupport("name=LastLoadTime", "descriptorType=attribute", "default=0", "displayName=Last Load Time", "getMethod=getLoadTime");
        ModelMBeanAttributeInfo[] mmbai = new ModelMBeanAttributeInfo[]{new ModelMBeanAttributeInfo("LastLoadDate", "java.util.Date", "Last Load Date", true, false, false, lastLoadDateDesc), new ModelMBeanAttributeInfo("LastLoadTime", "java.lang.Long", "Last Load Time", true, false, false, lastLoadTimeDesc)};
        ModelMBeanOperationInfo[] mmboi = new ModelMBeanOperationInfo[7];
        mmboi[0] = new ModelMBeanOperationInfo("start", "Start DSpace Kernel", null, "void", 1);
        mmboi[1] = new ModelMBeanOperationInfo("stop", "Stop DSpace Kernel", null, "void", 1);
        mmboi[2] = new ModelMBeanOperationInfo("getManagedBean", "Get the Current Kernel", null, DSpaceKernel.class.getName(), 0);
        return new ModelMBeanInfoSupport(this.getClass().getName(), "DSpace Kernel", mmbai, null, mmboi, null);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if ("LastLoadDate".equals(attribute)) {
            return this.getLastLoadDate();
        }
        if ("LastLoadTime".equals(attribute)) {
            return this.getLoadTime();
        }
        throw new AttributeNotFoundException("invalid attribute: " + attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new InvalidAttributeValueException("Cannot set attribute: " + attribute);
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }
}

