/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dspace.servicemanager.ServiceConfig;
import org.dspace.servicemanager.config.DSpaceConfig;
import org.dspace.services.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class DSpaceConfigurationService
implements ConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(DSpaceConfigurationService.class);
    public static final String DSPACE_WEB_CONTEXT_PARAM = "dspace-config";
    public static final String DSPACE = "dspace";
    public static final String EXT_CONFIG = "cfg";
    public static final String DOT_CONFIG = ".cfg";
    public static final String DSPACE_PREFIX = "dspace.";
    public static final String DSPACE_HOME = "dspace.dir";
    public static final String DEFAULT_CONFIGURATION_FILE_NAME = "dspace-defaults.cfg";
    public static final String DEFAULT_DSPACE_CONFIG_PATH = "config/dspace-defaults.cfg";
    public static final String DSPACE_CONFIG_PATH = "config/dspace.cfg";
    public static final String DSPACE_MODULES_CONFIG_PATH = "config" + File.separator + "modules";
    protected transient Map<String, Map<String, ServiceConfig>> serviceNameConfigs;
    public static final String DSPACE_CONFIG_ADDON = "dspace/config-*";
    protected Map<String, DSpaceConfig> configuration = Collections.synchronizedMap(new LinkedHashMap());

    public DSpaceConfigurationService() {
        this.loadInitialConfig(null);
    }

    public DSpaceConfigurationService(String providedHome) {
        this.loadInitialConfig(providedHome);
    }

    @Override
    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (DSpaceConfig config : this.configuration.values()) {
            props.put(config.getKey(), config.getValue());
        }
        return props;
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        for (DSpaceConfig config : this.configuration.values()) {
            props.put(config.getKey(), config.getValue());
        }
        return props;
    }

    @Override
    public String getProperty(String name) {
        DSpaceConfig config = this.configuration.get(name);
        String value = null;
        if (config != null) {
            value = config.getValue();
        }
        return value;
    }

    @Override
    public <T> T getPropertyAsType(String name, Class<T> type) {
        String value = this.getProperty(name);
        return this.convert(value, type);
    }

    @Override
    public <T> T getPropertyAsType(String name, T defaultValue) {
        return this.getPropertyAsType(name, defaultValue, false);
    }

    @Override
    public <T> T getPropertyAsType(String name, T defaultValue, boolean setDefaultIfNotFound) {
        String value = this.getProperty(name);
        T property = null;
        if (defaultValue == null) {
            property = null;
        } else if (value == null) {
            property = defaultValue;
            if (setDefaultIfNotFound) {
                this.setProperty(name, defaultValue);
            }
        } else {
            property = (T)this.convert(value, defaultValue.getClass());
        }
        return property;
    }

    @Override
    public boolean setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null for setting configuration");
        }
        boolean changed = false;
        if (value == null) {
            changed = this.configuration.remove(name) != null;
            log.info("Cleared the configuration setting for name (" + name + ")");
        } else {
            SimpleTypeConverter converter = new SimpleTypeConverter();
            String sVal = (String)converter.convertIfNecessary(value, String.class);
            changed = this.loadConfig(name, sVal);
        }
        return changed;
    }

    public List<DSpaceConfig> getConfiguration() {
        return new ArrayList<DSpaceConfig>(this.configuration.values());
    }

    public List<DSpaceConfig> getConfigsByPrefix(String prefix) {
        ArrayList<DSpaceConfig> configs = new ArrayList<DSpaceConfig>();
        if (prefix != null && prefix.length() > 0) {
            for (DSpaceConfig config : this.configuration.values()) {
                if (!config.getKey().startsWith(prefix)) continue;
                configs.add(config);
            }
        }
        return configs;
    }

    public Map<String, Map<String, ServiceConfig>> getServiceNameConfigs() {
        return this.serviceNameConfigs;
    }

    public void setConfiguration(Map<String, DSpaceConfig> configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        this.configuration = configuration;
        this.replaceVariables(this.configuration);
        this.serviceNameConfigs = this.makeServiceNameConfigs();
    }

    public String[] loadConfiguration(Map<String, String> properties, boolean clear) {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null");
        }
        ArrayList<DSpaceConfig> dspaceConfigs = new ArrayList<DSpaceConfig>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String val;
            String key = entry.getKey();
            if (key == null || "".equals(key) || (val = entry.getValue()) == null || "".equals(val)) continue;
            dspaceConfigs.add(new DSpaceConfig(entry.getKey(), entry.getValue()));
        }
        return this.loadConfiguration(dspaceConfigs, clear);
    }

    public String[] loadConfiguration(List<DSpaceConfig> dspaceConfigs, boolean clear) {
        ArrayList<String> changed = new ArrayList<String>();
        if (clear) {
            this.configuration.clear();
        }
        for (DSpaceConfig config : dspaceConfigs) {
            String key = config.getKey();
            boolean same = true;
            if (clear) {
                same = false;
            } else if (this.configuration.containsKey(key)) {
                if (this.configuration.get(key).equals(config)) {
                    same = false;
                }
            } else {
                same = false;
            }
            if (same) continue;
            changed.add(key);
            this.configuration.put(key, config);
        }
        if (changed.size() > 0) {
            this.replaceVariables(this.configuration);
            this.serviceNameConfigs = this.makeServiceNameConfigs();
        }
        return changed.toArray(new String[changed.size()]);
    }

    public boolean loadConfig(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        boolean changed = this.replaceAndAddConfig(new DSpaceConfig(key, value));
        if (changed) {
            this.serviceNameConfigs = this.makeServiceNameConfigs();
        }
        return changed;
    }

    public void clear() {
        this.configuration.clear();
        this.serviceNameConfigs.clear();
        log.info("Cleared all configuration settings");
    }

    public void loadInitialConfig(String providedHome) {
        String homePath;
        LinkedHashMap<String, String> configMap;
        block21: {
            String prefix;
            Resource[] resources;
            String catalina;
            configMap = new LinkedHashMap<String, String>();
            try {
                String defaultServerId = InetAddress.getLocalHost().getHostName();
                configMap.put("serverId", defaultServerId);
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            configMap.put("dspace.testing", "false");
            homePath = System.getProperty(DSPACE_HOME);
            if (providedHome != null && homePath == null) {
                homePath = providedHome;
            }
            if (homePath == null && (catalina = this.getCatalina()) != null) {
                homePath = catalina + File.separatorChar + DSPACE + File.separatorChar;
            }
            if (homePath == null) {
                homePath = System.getProperty("user.home");
            }
            if (homePath == null) {
                homePath = "/";
            }
            configMap.put(DSPACE_HOME, homePath);
            Properties defaultProps = this.readPropertyResource(DEFAULT_DSPACE_CONFIG_PATH);
            if (defaultProps.size() <= 0) {
                throw new RuntimeException("Failed to load default dspace config properties: config/dspace-defaults.cfg");
            }
            this.pushPropsToMap(configMap, defaultProps);
            Properties systemProps = System.getProperties();
            for (Object o : systemProps.keySet()) {
                String key = (String)o;
                if (key == null || key.equals(DSPACE_HOME)) continue;
                try {
                    if (!key.startsWith(DSPACE_PREFIX)) continue;
                    String propName = key.substring(DSPACE_PREFIX.length());
                    String propVal = systemProps.getProperty(key);
                    log.info("Loading system property as config: " + propName + "=>" + propVal);
                    configMap.put(propName, propVal);
                }
                catch (RuntimeException e) {
                    log.error("Failed to properly get config value from system property: " + o, (Throwable)e);
                }
            }
            try {
                PathMatchingResourcePatternResolver patchMatcher = new PathMatchingResourcePatternResolver();
                for (Resource resource : resources = patchMatcher.getResources("classpath*:dspace/config-*.cfg")) {
                    prefix = resource.getFilename().substring(0, resource.getFilename().lastIndexOf(".")).replaceFirst("config-", "");
                    this.pushPropsToMap(configMap, prefix, this.readPropertyStream(resource.getInputStream()));
                }
            }
            catch (Exception e) {
                log.error("Failed to retrieve properties from classpath: " + e.getMessage(), (Throwable)e);
            }
            try {
                File modulesDirectory = new File(homePath + File.separator + DSPACE_MODULES_CONFIG_PATH + File.separator);
                if (modulesDirectory.exists()) {
                    try {
                        resources = new PathMatchingResourcePatternResolver().getResources(modulesDirectory.toURI().toURL().toString() + "*" + DOT_CONFIG);
                        if (resources != null) {
                            for (Resource resource : resources) {
                                prefix = resource.getFilename().substring(0, resource.getFilename().lastIndexOf("."));
                                this.pushPropsToMap(configMap, prefix, this.readPropertyStream(resource.getInputStream()));
                            }
                        }
                        break block21;
                    }
                    catch (IOException e) {
                        log.error("Error while loading the modules properties from:" + modulesDirectory.getAbsolutePath());
                        break block21;
                    }
                }
                log.info("Failed to load the modules properties since (" + homePath + File.separator + DSPACE_MODULES_CONFIG_PATH + "): Does not exist");
            }
            catch (IllegalArgumentException e) {
                log.error("Error while loading the module properties since (" + homePath + File.separator + DSPACE_MODULES_CONFIG_PATH + "): is not a valid directory", (Throwable)e);
            }
        }
        this.pushPropsToMap(configMap, this.readPropertyResource("dspace.cfg"));
        String configPath = System.getProperty("dspace.configuration");
        if (null == configPath) {
            configPath = homePath + File.separatorChar + DSPACE_CONFIG_PATH;
        }
        this.pushPropsToMap(configMap, this.readPropertyFile(configPath));
        this.loadConfiguration(configMap, true);
        log.info("Started up configuration service and loaded " + configMap.size() + " settings");
    }

    protected boolean replaceAndAddConfig(DSpaceConfig dsConfig) {
        DSpaceConfig newConfig = null;
        String key = dsConfig.getKey();
        if (dsConfig.getValue().contains("${")) {
            String value = dsConfig.getValue();
            int start = -1;
            while ((start = value.indexOf("${")) > -1) {
                int end = value.indexOf(125, start);
                if (end > -1) {
                    String newKey = value.substring(start + 2, end);
                    if (newKey.equals(key)) {
                        log.warn("Found circular reference for key (" + newKey + ") in config value: " + value);
                        break;
                    }
                    DSpaceConfig dsc = this.configuration.get(newKey);
                    if (dsc == null) {
                        log.warn("Could not find key (" + newKey + ") for replacement in value: " + value);
                        break;
                    }
                    String newVal = dsc.getValue();
                    value = value.replace("${" + newKey + "}", newVal);
                    newConfig = new DSpaceConfig(key, value);
                    continue;
                }
                log.warn("Found '${' but could not find a closing '}' in the value: " + value);
                break;
            }
        }
        if (this.configuration.containsKey(key) && this.configuration.get(key).equals(dsConfig)) {
            return false;
        }
        this.configuration.put(key, newConfig != null ? newConfig : dsConfig);
        this.replaceVariables(this.configuration);
        return true;
    }

    protected void replaceVariables(Map<String, DSpaceConfig> dsConfiguration) {
        block0: for (Map.Entry<String, DSpaceConfig> entry : dsConfiguration.entrySet()) {
            if (!entry.getValue().getValue().contains("${")) continue;
            String value = entry.getValue().getValue();
            int start = -1;
            while ((start = value.indexOf("${")) > -1) {
                int end = value.indexOf(125, start);
                if (end > -1) {
                    String newKey = value.substring(start + 2, end);
                    DSpaceConfig dsc = dsConfiguration.get(newKey);
                    if (dsc == null) {
                        log.warn("Could not find key (" + newKey + ") for replacement in value: " + value);
                        continue block0;
                    }
                    String newVal = dsc.getValue();
                    String oldValue = value;
                    if ((value = value.replace("${" + newKey + "}", newVal)).equals(oldValue)) {
                        log.warn("No change after variable replacement -- is " + newKey + " = " + newVal + " a circular reference?");
                        continue block0;
                    }
                    entry.setValue(new DSpaceConfig(entry.getValue().getKey(), value));
                    continue;
                }
                log.warn("Found '${' but could not find a closing '}' in the value: " + value);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties readPropertyFile(String filePathName) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            File f = new File(filePathName);
            if (f.exists()) {
                is = new FileInputStream(f);
                props.load(is);
                log.info("Loaded " + props.size() + " config properties from file: " + f);
            } else {
                log.info("Failed to load config properties from file (" + filePathName + "): Does not exist");
            }
        }
        catch (Exception e) {
            log.warn("Failed to load config properties from file (" + filePathName + "): " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        return props;
    }

    protected Properties readPropertyResource(String resourcePathName) {
        Properties props = new Properties();
        try {
            ClassPathResource resource = new ClassPathResource(resourcePathName);
            if (resource.exists()) {
                props.load(resource.getInputStream());
                log.info("Loaded " + props.size() + " config properties from resource: " + resource);
            }
        }
        catch (Exception e) {
            log.warn("Failed to load config properties from resource (" + resourcePathName + "): " + e.getMessage(), (Throwable)e);
        }
        return props;
    }

    protected Properties readPropertyFile(File propertyFile) {
        Properties props = new Properties();
        try {
            if (propertyFile.exists()) {
                props.load(new FileInputStream(propertyFile));
                log.info("Loaded" + props.size() + " config properties from file: " + propertyFile.getName());
            }
        }
        catch (Exception e) {
            log.warn("Failed to load config properties from file (" + propertyFile.getName() + ": " + e.getMessage(), (Throwable)e);
        }
        return props;
    }

    protected Properties readPropertyStream(InputStream propertyStream) {
        Properties props = new Properties();
        try {
            props.load(propertyStream);
            log.info("Loaded" + props.size() + " config properties from stream");
        }
        catch (Exception e) {
            log.warn("Failed to load config properties from stream: " + e.getMessage(), (Throwable)e);
        }
        return props;
    }

    protected void pushPropsToMap(Map<String, String> map, Properties props) {
        this.pushPropsToMap(map, null, props);
    }

    protected void pushPropsToMap(Map<String, String> map, String prefix, Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            if (prefix != null) {
                key = prefix + "." + key;
            }
            map.put(key, entry.getValue() == null ? "" : entry.getValue().toString());
        }
    }

    protected String getCatalina() {
        String catalina = System.getProperty("catalina.base");
        if (catalina == null) {
            catalina = System.getProperty("catalina.home");
        }
        return catalina;
    }

    public String toString() {
        return "Config:dspace.dir:size=" + this.configuration.size();
    }

    public Map<String, Map<String, ServiceConfig>> makeServiceNameConfigs() {
        HashMap<String, Map<String, ServiceConfig>> serviceNameConfigs = new HashMap<String, Map<String, ServiceConfig>>();
        for (DSpaceConfig dsConfig : this.getConfiguration()) {
            String beanName = dsConfig.getBeanName();
            if (beanName == null) continue;
            Map<String, ServiceConfig> map = null;
            if (serviceNameConfigs.containsKey(beanName)) {
                map = (Map)serviceNameConfigs.get(beanName);
            } else {
                map = new HashMap();
                serviceNameConfigs.put(beanName, map);
            }
            map.put(beanName, new ServiceConfig(dsConfig));
        }
        return serviceNameConfigs;
    }

    private <T> T convert(String value, Class<T> type) {
        SimpleTypeConverter converter = new SimpleTypeConverter();
        if (value != null) {
            if (type.isArray()) {
                String[] values = value.split(",");
                return (T)converter.convertIfNecessary((Object)values, type);
            }
            if (type.isAssignableFrom(String.class)) {
                return (T)value;
            }
        } else {
            if (Boolean.TYPE.equals(type)) {
                return (T)Boolean.FALSE;
            }
            if (Integer.TYPE.equals(type) || Long.TYPE.equals(type)) {
                return (T)converter.convertIfNecessary((Object)0, type);
            }
        }
        return (T)converter.convertIfNecessary((Object)value, type);
    }
}

