/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.kernel.config.SpringLoader;
import org.dspace.servicemanager.DSpaceServiceManager;
import org.dspace.servicemanager.ServiceManagerSystem;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.servicemanager.spring.DSpaceBeanFactoryPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class SpringServiceManager
implements ServiceManagerSystem {
    private static Logger log = LoggerFactory.getLogger(SpringServiceManager.class);
    private ClassPathXmlApplicationContext applicationContext;
    private final ServiceManagerSystem parent;
    private final DSpaceConfigurationService configurationService;
    private boolean testMode = false;
    private boolean developmentMode = false;
    private String[] configPaths = null;
    public static final String configPath = "spring/spring-dspace-applicationContext.xml";
    public static final String coreResourcePath = "classpath*:spring/spring-dspace-core-services.xml";
    public static final String addonResourcePath = "classpath*:spring/spring-dspace-addon-*-services.xml";

    public ClassPathXmlApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ListableBeanFactory getBeanFactory() {
        if (this.applicationContext != null) {
            return this.applicationContext.getBeanFactory();
        }
        return null;
    }

    public SpringServiceManager(ServiceManagerSystem parent, DSpaceConfigurationService configurationService, boolean testMode, boolean developmentMode, String ... configPaths) {
        if (parent == null) {
            throw new IllegalArgumentException("parent SMS cannot be null");
        }
        this.parent = parent;
        if (configurationService == null) {
            throw new IllegalArgumentException("configuration service cannot be null");
        }
        this.configurationService = configurationService;
        this.testMode = testMode;
        this.developmentMode = developmentMode;
        this.configPaths = configPaths;
    }

    @Override
    public <T> T getServiceByName(String name, Class<T> type) {
        Object bean = null;
        if (ApplicationContext.class.getName().equals(name) && ApplicationContext.class.isAssignableFrom(type)) {
            bean = this.getApplicationContext();
        } else {
            if (name != null) {
                try {
                    bean = this.applicationContext.getBean(name, type);
                }
                catch (BeansException e) {
                    bean = null;
                }
            } else {
                try {
                    bean = this.applicationContext.getBean(type.getName(), type);
                }
                catch (BeansException e) {
                    bean = null;
                }
            }
            if (name == null && bean == null) {
                try {
                    Map map = this.applicationContext.getBeansOfType(type);
                    if (map.size() == 1) {
                        bean = map.values().iterator().next();
                    }
                }
                catch (BeansException e) {
                    bean = null;
                }
            }
        }
        return (T)bean;
    }

    @Override
    public <T> List<T> getServicesByType(Class<T> type) {
        ArrayList l = new ArrayList();
        try {
            Map beans = this.applicationContext.getBeansOfType(type, true, true);
            l.addAll(beans.values());
        }
        catch (BeansException e) {
            throw new RuntimeException("Failed to get beans of type (" + type + "): " + e.getMessage(), e);
        }
        return l;
    }

    @Override
    public void shutdown() {
        if (this.applicationContext != null) {
            try {
                this.applicationContext.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.applicationContext.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.applicationContext = null;
            log.info("Spring Service Manager Shutdown...");
        }
    }

    @Override
    public void startup() {
        long startTime = System.currentTimeMillis();
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(configPath);
        pathList.add(addonResourcePath);
        if (this.testMode) {
            log.warn("TEST Spring Service Manager running in test mode, no core beans will be started");
        } else {
            pathList.add(coreResourcePath);
        }
        if (this.configPaths != null) {
            pathList.addAll(Arrays.asList(this.configPaths));
        }
        if (this.testMode) {
            log.warn("TEST Spring Service Manager running in test mode, no dspace home spring files will be loaded");
        } else {
            String[] springLoaderClassNames = this.configurationService.getPropertyAsType("spring.springloader.modules", new String[0]);
            if (springLoaderClassNames != null) {
                for (String springLoaderClassName : springLoaderClassNames) {
                    try {
                        Class<?> springLoaderClass = Class.forName(springLoaderClassName.trim());
                        String[] resourcePaths = ((SpringLoader)springLoaderClass.getConstructor(new Class[0]).newInstance(new Object[0])).getResourcePaths(this.configurationService);
                        if (resourcePaths == null) continue;
                        pathList.addAll(Arrays.asList(resourcePaths));
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (Exception e) {
                        log.error("Error while retrieving spring resource paths for module: " + springLoaderClassName, (Throwable)e);
                    }
                }
            }
        }
        String[] allPaths = pathList.toArray(new String[pathList.size()]);
        this.applicationContext = new ClassPathXmlApplicationContext(allPaths, false);
        this.applicationContext.setAllowBeanDefinitionOverriding(true);
        this.applicationContext.setAllowCircularReferences(false);
        this.applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new DSpaceBeanFactoryPostProcessor(this.parent, this.configurationService, this.testMode));
        this.applicationContext.refresh();
        if (this.developmentMode) {
            log.warn("Spring Service Manager is running in developmentMode, services will be loaded on demand only");
        } else {
            this.applicationContext.getBeanFactory().preInstantiateSingletons();
            this.applicationContext.getBeanFactory().freezeConfiguration();
        }
        long totalTime = System.currentTimeMillis() - startTime;
        log.info("Spring Service Manager started up in " + totalTime + " ms with " + this.applicationContext.getBeanDefinitionCount() + " services...");
    }

    @Override
    public <T> T registerServiceClass(String name, Class<T> type) {
        Object service;
        if (name == null || type == null) {
            throw new IllegalArgumentException("name and type must not be null for service registration");
        }
        try {
            service = this.applicationContext.getBeanFactory().autowire(type, 2, true);
            this.registerBean(name, service);
        }
        catch (BeansException e) {
            throw new IllegalArgumentException("Invalid service class (" + type + ") with name (" + name + ") registration: " + e.getMessage(), e);
        }
        return (T)service;
    }

    @Override
    public void registerService(String name, Object service) {
        if (name == null || service == null) {
            throw new IllegalArgumentException("name and service must not be null for service registration");
        }
        try {
            this.applicationContext.getBeanFactory().autowireBean(service);
        }
        catch (BeansException e) {
            throw new IllegalArgumentException("Invalid service (" + service + ") with name (" + name + ") registration: " + e.getMessage(), e);
        }
        this.registerBean(name, service);
    }

    private void registerBean(String name, Object service) {
        try {
            this.applicationContext.getBeanFactory().initializeBean(service, name);
            this.applicationContext.getBeanFactory().registerSingleton(name, service);
        }
        catch (BeansException e) {
            throw new IllegalArgumentException("Invalid service (" + service + ") with name (" + name + ") registration: " + e.getMessage(), e);
        }
    }

    @Override
    public void unregisterService(String name) {
        if (this.applicationContext.containsBean(name)) {
            try {
                Object beanInstance = this.applicationContext.getBean(name);
                try {
                    this.applicationContext.getBeanFactory().destroyBean(name, beanInstance);
                }
                catch (NoSuchBeanDefinitionException e) {
                    DSpaceServiceManager.shutdownService(beanInstance);
                }
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
    }

    @Override
    public List<String> getServicesNames() {
        String[] singletons;
        ArrayList<String> beanNames = new ArrayList<String>();
        for (String singleton : singletons = this.applicationContext.getBeanFactory().getSingletonNames()) {
            if (singleton.startsWith("org.springframework.context")) continue;
            beanNames.add(singleton);
        }
        Collections.sort(beanNames);
        return beanNames;
    }

    @Override
    public boolean isServiceExists(String name) {
        return this.applicationContext.containsBean(name);
    }

    @Override
    public Map<String, Object> getServices() {
        String[] singletons;
        HashMap<String, Object> services = new HashMap<String, Object>();
        for (String singleton : singletons = this.applicationContext.getBeanFactory().getSingletonNames()) {
            if (singleton.startsWith("org.springframework.context")) continue;
            String beanName = singleton;
            Object service = this.applicationContext.getBeanFactory().getSingleton(beanName);
            if (service == null) continue;
            services.put(beanName, service);
        }
        return services;
    }

    @Override
    public void pushConfig(Map<String, String> settings) {
        throw new UnsupportedOperationException("Not implemented for individual service manager systems");
    }
}

