/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.caching;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Statistics;
import org.dspace.kernel.ServiceManager;
import org.dspace.kernel.mixins.ConfigChangeListener;
import org.dspace.kernel.mixins.InitializedService;
import org.dspace.kernel.mixins.ServiceChangeListener;
import org.dspace.kernel.mixins.ShutdownService;
import org.dspace.providers.CacheProvider;
import org.dspace.services.CachingService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.RequestService;
import org.dspace.services.caching.model.EhcacheCache;
import org.dspace.services.caching.model.MapCache;
import org.dspace.services.model.Cache;
import org.dspace.services.model.CacheConfig;
import org.dspace.services.model.RequestInterceptor;
import org.dspace.services.model.Session;
import org.dspace.utils.servicemanager.ProviderHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public final class CachingServiceImpl
implements CachingService,
InitializedService,
ShutdownService,
ConfigChangeListener,
ServiceChangeListener {
    private static Logger log = LoggerFactory.getLogger(CachingServiceImpl.class);
    protected static final String EVENT_RESET = "caching.reset";
    protected static final String DEFAULT_CONFIG = "org/dspace/services/caching/ehcache-config.xml";
    private Map<String, EhcacheCache> cacheRecord = new ConcurrentHashMap<String, EhcacheCache>();
    private Map<String, Map<String, MapCache>> requestCachesMap = new ConcurrentHashMap<String, Map<String, MapCache>>();
    private ConfigurationService configurationService;
    private RequestService requestService;
    private ServiceManager serviceManager;
    protected CacheManager cacheManager;
    private boolean useClustering = false;
    private boolean useDiskStore = true;
    private int maxElementsInMemory = 2000;
    private int timeToLiveSecs = 3600;
    private int timeToIdleSecs = 600;
    private String[] knownConfigNames = new String[]{"caching.use.clustering", "caching.default.use.disk.store", "caching.default.max.elements", "caching.default.time.to.live.secs", "caching.default.time.to.idle.secs"};
    private ProviderHolder<CacheProvider> provider = new ProviderHolder();

    protected Map<String, MapCache> getRequestCaches() {
        if (this.requestService == null || this.requestService.getCurrentRequestId() == null) {
            return null;
        }
        Map<String, MapCache> requestCaches = this.requestCachesMap.get(this.requestService.getCurrentRequestId());
        if (requestCaches == null) {
            requestCaches = new HashMap<String, MapCache>();
            this.requestCachesMap.put(this.requestService.getCurrentRequestId(), requestCaches);
        }
        return requestCaches;
    }

    @Override
    public void unbindRequestCaches() {
        if (this.requestService != null) {
            this.requestCachesMap.remove(this.requestService.getCurrentRequestId());
        }
    }

    @Autowired
    @Required
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Autowired
    public void setRequestService(RequestService requestService) {
        this.requestService = requestService;
    }

    @Autowired
    @Required
    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Autowired
    @Required
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected void reloadConfig() {
        this.useClustering = (Boolean)((Object)this.configurationService.getPropertyAsType(this.knownConfigNames[0], Boolean.TYPE));
        this.useDiskStore = (Boolean)((Object)this.configurationService.getPropertyAsType(this.knownConfigNames[1], Boolean.TYPE));
        this.maxElementsInMemory = (Integer)((Object)this.configurationService.getPropertyAsType(this.knownConfigNames[2], Integer.TYPE));
        this.timeToLiveSecs = (Integer)((Object)this.configurationService.getPropertyAsType(this.knownConfigNames[3], Integer.TYPE));
        this.timeToIdleSecs = (Integer)((Object)this.configurationService.getPropertyAsType(this.knownConfigNames[4], Integer.TYPE));
    }

    @Override
    public String[] notifyForConfigNames() {
        return this.knownConfigNames == null ? null : (String[])this.knownConfigNames.clone();
    }

    @Override
    public void configurationChanged(List<String> changedSettingNames, Map<String, String> changedSettings) {
        this.reloadConfig();
    }

    public CacheProvider getCacheProvider() {
        return this.provider.getProvider();
    }

    private void reloadProvider() {
        boolean current = this.getCacheProvider() != null;
        CacheProvider cacheProvider = this.serviceManager.getServiceByName(CacheProvider.class.getName(), CacheProvider.class);
        this.provider.setProvider(cacheProvider);
        if (cacheProvider != null) {
            log.info("Cache Provider loaded: " + cacheProvider.getClass().getName());
        } else if (current) {
            log.info("Cache Provider unloaded");
        }
    }

    @Override
    public Class<?>[] notifyForTypes() {
        return new Class[]{CacheProvider.class};
    }

    @Override
    public void serviceRegistered(String serviceName, Object service, List<Class<?>> implementedTypes) {
        this.provider.setProvider((CacheProvider)service);
    }

    @Override
    public void serviceUnregistered(String serviceName, Object service) {
        this.provider.setProvider(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        log.info("init()");
        this.reloadConfig();
        System.setProperty("net.sf.ehcache.skipUpdateCheck", "true");
        if (this.cacheManager == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(DEFAULT_CONFIG);
            try {
                if (is == null) {
                    throw new IllegalStateException("Could not init the cache manager, no config file found as a resource in the classloader: org/dspace/services/caching/ehcache-config.xml");
                }
                this.cacheManager = new CacheManager(is);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.debug("Error closing config stream", (Throwable)e);
                    }
                }
            }
        }
        List<Ehcache> ehcaches = this.getAllEhCaches(false);
        for (Ehcache ehcache : ehcaches) {
            EhcacheCache cache = new EhcacheCache(ehcache, null);
            this.cacheRecord.put(cache.getName(), cache);
        }
        this.reloadProvider();
        if (this.requestService != null) {
            this.requestService.registerRequestInterceptor(new CachingServiceRequestInterceptor());
        }
        log.info("Caching service initialized:\n" + this.getStatus(null));
    }

    @Override
    public void shutdown() {
        log.info("destroy()");
        try {
            if (this.cacheRecord != null) {
                this.cacheRecord.clear();
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.requestCachesMap.clear();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.cacheManager.removalAll();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.cacheManager.shutdown();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void destroyCache(String cacheName) {
        EhcacheCache cache;
        if (cacheName == null || "".equals(cacheName)) {
            throw new IllegalArgumentException("cacheName cannot be null or empty string");
        }
        if (this.getCacheProvider() != null) {
            try {
                this.getCacheProvider().destroyCache(cacheName);
            }
            catch (Exception e) {
                log.warn("Failure in provider (" + this.getCacheProvider() + "): " + e.getMessage());
            }
        }
        if ((cache = this.cacheRecord.get(cacheName)) != null) {
            this.cacheManager.removeCache(cacheName);
            this.cacheRecord.remove(cacheName);
        } else {
            Map<String, MapCache> caches = this.getRequestCaches();
            if (caches != null) {
                caches.remove(cacheName);
            }
        }
    }

    @Override
    public Cache getCache(String cacheName, CacheConfig cacheConfig) {
        Cache cache = null;
        if (cacheName == null || "".equals(cacheName)) {
            throw new IllegalArgumentException("cacheName cannot be null or empty string");
        }
        if (cacheConfig != null && CacheConfig.CacheScope.REQUEST.equals((Object)cacheConfig.getCacheScope())) {
            Map<String, MapCache> caches = this.getRequestCaches();
            if (caches != null) {
                cache = caches.get(cacheName);
            }
            if (cache == null) {
                cache = this.instantiateMapCache(cacheName, cacheConfig);
            }
        } else {
            cache = this.cacheRecord.get(cacheName);
            if (cache == null && this.getCacheProvider() != null) {
                try {
                    cache = this.getCacheProvider().getCache(cacheName, cacheConfig);
                }
                catch (Exception e) {
                    log.warn("Failure in provider (" + this.getCacheProvider() + "): " + e.getMessage());
                }
            }
            if (cache == null) {
                cache = this.instantiateEhCache(cacheName, cacheConfig);
            }
        }
        return cache;
    }

    @Override
    public List<Cache> getCaches() {
        ArrayList<Cache> caches = new ArrayList<Cache>(this.cacheRecord.values());
        if (this.getCacheProvider() != null) {
            try {
                caches.addAll(this.getCacheProvider().getCaches());
            }
            catch (Exception e) {
                log.warn("Failure in provider (" + this.getCacheProvider() + "): " + e.getMessage());
            }
        }
        Collections.sort(caches, new NameComparator());
        return caches;
    }

    @Override
    public String getStatus(String cacheName) {
        StringBuilder sb = new StringBuilder();
        if (cacheName == null || "".equals(cacheName)) {
            sb.append("** Memory report\n");
            sb.append(" freeMemory: ").append(Runtime.getRuntime().freeMemory());
            sb.append("\n");
            sb.append(" totalMemory: ").append(Runtime.getRuntime().totalMemory());
            sb.append("\n");
            sb.append(" maxMemory: ").append(Runtime.getRuntime().maxMemory());
            sb.append("\n");
            List<Cache> allCaches = this.getCaches();
            sb.append("\n** Full report of all known caches (").append(allCaches.size()).append("):\n");
            for (Cache cache : allCaches) {
                sb.append(" * ");
                sb.append(cache.toString());
                sb.append("\n");
                if (!(cache instanceof EhcacheCache)) continue;
                Ehcache ehcache = ((EhcacheCache)cache).getCache();
                sb.append(CachingServiceImpl.generateCacheStats(ehcache));
                sb.append("\n");
            }
        } else {
            Map<String, MapCache> caches;
            sb.append("\n** Report for cache (").append(cacheName).append("):\n");
            Cache cache = this.cacheRecord.get(cacheName);
            if (cache == null && (caches = this.getRequestCaches()) != null) {
                cache = caches.get(cacheName);
            }
            if (cache == null) {
                sb.append(" * Could not find cache by this name: ").append(cacheName);
            } else {
                sb.append(" * ");
                sb.append(cache.toString());
                sb.append("\n");
                if (cache instanceof EhcacheCache) {
                    Ehcache ehcache = ((EhcacheCache)cache).getCache();
                    sb.append(CachingServiceImpl.generateCacheStats(ehcache));
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void resetCaches() {
        log.debug("resetCaches()");
        List<Cache> allCaches = this.getCaches();
        for (Cache cache : allCaches) {
            cache.clear();
        }
        if (this.getCacheProvider() != null) {
            try {
                this.getCacheProvider().resetCaches();
            }
            catch (Exception e) {
                log.warn("Failure in provider (" + this.getCacheProvider() + "): " + e.getMessage());
            }
        }
        System.runFinalization();
        log.info("doReset(): Memory Recovery to: " + Runtime.getRuntime().freeMemory());
    }

    protected List<Ehcache> getAllEhCaches(boolean sorted) {
        log.debug("getAllCaches()");
        Object[] cacheNames = this.cacheManager.getCacheNames();
        if (sorted) {
            Arrays.sort(cacheNames);
        }
        ArrayList<Ehcache> caches = new ArrayList<Ehcache>(cacheNames.length);
        for (Object cacheName : cacheNames) {
            caches.add(this.cacheManager.getEhcache((String)cacheName));
        }
        return caches;
    }

    protected EhcacheCache instantiateEhCache(String cacheName, CacheConfig cacheConfig) {
        if (log.isDebugEnabled()) {
            log.debug("instantiateEhCache(String " + cacheName + ")");
        }
        if (cacheName == null || "".equals(cacheName)) {
            throw new IllegalArgumentException("String cacheName must not be null or empty!");
        }
        Ehcache ehcache = this.serviceManager.getServiceByName(cacheName, Ehcache.class);
        if (ehcache == null) {
            if (!this.cacheManager.cacheExists(cacheName)) {
                if (cacheConfig == null) {
                    this.cacheManager.addCache(cacheName);
                } else {
                    if (this.useClustering) {
                        throw new UnsupportedOperationException("Still need to do this");
                    }
                    this.cacheManager.addCache(cacheName);
                }
                log.info("Created new Cache (from default settings): " + cacheName);
            }
            ehcache = this.cacheManager.getEhcache(cacheName);
        }
        EhcacheCache cache = new EhcacheCache(ehcache, cacheConfig);
        this.cacheRecord.put(cacheName, cache);
        return cache;
    }

    protected MapCache instantiateMapCache(String cacheName, CacheConfig cacheConfig) {
        Map<String, MapCache> caches;
        if (log.isDebugEnabled()) {
            log.debug("instantiateMapCache(String " + cacheName + ")");
        }
        if (cacheName == null || "".equals(cacheName)) {
            throw new IllegalArgumentException("String cacheName must not be null or empty!");
        }
        MapCache cache = null;
        CacheConfig.CacheScope scope = CacheConfig.CacheScope.REQUEST;
        if (cacheConfig != null) {
            scope = cacheConfig.getCacheScope();
        }
        if ((caches = this.getRequestCaches()) != null) {
            if (CacheConfig.CacheScope.REQUEST.equals((Object)scope)) {
                cache = caches.get(cacheName);
            }
            if (cache == null) {
                cache = new MapCache(cacheName, cacheConfig);
                if (CacheConfig.CacheScope.REQUEST.equals((Object)scope)) {
                    caches.put(cacheName, cache);
                }
            }
        }
        return cache;
    }

    protected static String generateCacheStats(Ehcache cache) {
        StringBuilder sb = new StringBuilder();
        sb.append(cache.getName()).append(":");
        cache.setStatisticsAccuracy(2);
        Statistics stats = cache.getStatistics();
        long memSize = cache.getMemoryStoreSize();
        long diskSize = cache.getDiskStoreSize();
        long size = memSize + diskSize;
        long hits = stats.getCacheHits();
        long misses = stats.getCacheMisses();
        String hitPercentage = hits + misses > 0L ? 100L * hits / (hits + misses) + "%" : "N/A";
        String missPercentage = hits + misses > 0L ? 100L * misses / (hits + misses) + "%" : "N/A";
        sb.append("  Size: ").append(size).append(" [memory:").append(memSize).append(", disk:").append(diskSize).append("]");
        sb.append(",  Hits: ").append(hits).append(" [memory:").append(stats.getInMemoryHits()).append(", disk:").append(stats.getOnDiskHits()).append("] (").append(hitPercentage).append(")");
        sb.append(",  Misses: ").append(misses).append(" (").append(missPercentage).append(")");
        return sb.toString();
    }

    private class CachingServiceRequestInterceptor
    implements RequestInterceptor {
        private CachingServiceRequestInterceptor() {
        }

        @Override
        public void onStart(String requestId, Session session) {
            HashMap requestCaches;
            if (requestId != null && (requestCaches = (HashMap)CachingServiceImpl.this.requestCachesMap.get(requestId)) == null) {
                requestCaches = new HashMap();
                CachingServiceImpl.this.requestCachesMap.put(requestId, requestCaches);
            }
        }

        @Override
        public void onEnd(String requestId, Session session, boolean succeeded, Exception failure) {
            if (requestId != null) {
                CachingServiceImpl.this.requestCachesMap.remove(requestId);
            }
        }

        @Override
        public int getOrder() {
            return 1;
        }
    }

    public static final class NameComparator
    implements Comparator<Cache>,
    Serializable {
        public static final long serialVersionUID = 1L;

        @Override
        public int compare(Cache o1, Cache o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

