/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.caching.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.dspace.services.model.Cache;
import org.dspace.services.model.CacheConfig;

public final class EhcacheCache
implements Cache {
    protected Ehcache cache;
    protected CacheConfig cacheConfig;

    public Ehcache getCache() {
        return this.cache;
    }

    public EhcacheCache(Ehcache cache, CacheConfig cacheConfig) {
        if (cache == null) {
            throw new NullPointerException("Cache must be set and cannot be null");
        }
        if (cache.getStatus() != Status.STATUS_ALIVE) {
            throw new IllegalArgumentException("Cache (" + cache.getName() + ") must already be initialized and alive");
        }
        this.cache = cache;
        this.cacheConfig = cacheConfig != null ? cacheConfig : new CacheConfig(CacheConfig.CacheScope.INSTANCE);
    }

    @Override
    public CacheConfig getConfig() {
        return this.cacheConfig;
    }

    @Override
    public void clear() {
        this.cache.removeAll();
        this.cache.clearStatistics();
    }

    @Override
    public boolean exists(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.cache.isKeyInCache((Object)key);
    }

    @Override
    public Object get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return (Serializable)this.getCachePayload(key, false);
    }

    @Override
    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        List eKeys = this.cache.getKeys();
        for (Object object : eKeys) {
            if (object == null) continue;
            keys.add(object.toString());
        }
        return keys;
    }

    @Override
    public Object look(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return (Serializable)this.getCachePayload(key, true);
    }

    @Override
    public void put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.cache.put(new Element((Object)key, value));
    }

    @Override
    public String getName() {
        if (this.cache != null) {
            return this.cache.getName();
        }
        return "NULL cache";
    }

    @Override
    public boolean remove(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.cache.remove((Serializable)((Object)key));
    }

    @Override
    public int size() {
        return this.cache.getSize();
    }

    private Object getCachePayload(String key, boolean quiet) {
        Object payload = null;
        Element e = quiet ? this.cache.getQuiet((Serializable)((Object)key)) : this.cache.get((Serializable)((Object)key));
        if (e != null) {
            payload = e.isSerializable() ? e.getValue() : e.getObjectValue();
        }
        return payload;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof EhcacheCache)) {
            return false;
        }
        EhcacheCache castObj = (EhcacheCache)obj;
        if (null == this.getName() || null == castObj.getName()) {
            return false;
        }
        return this.getName().equals(castObj.getName());
    }

    public int hashCode() {
        if (null == this.getName()) {
            return super.hashCode();
        }
        String hashStr = this.getClass().getName() + ":" + this.getName().hashCode();
        return hashStr.hashCode();
    }

    public String toString() {
        return "EhCache:name=" + this.getName() + ":Scope=" + (Object)((Object)this.cacheConfig.getCacheScope()) + ":size=" + this.size();
    }
}

