/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.email;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.dspace.kernel.mixins.InitializedService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.EmailService;
import org.dspace.utils.DSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class EmailServiceImpl
extends Authenticator
implements EmailService,
InitializedService {
    private static final Logger logger = LoggerFactory.getLogger(EmailServiceImpl.class);
    private Session session = null;
    private ConfigurationService cfg = null;

    @Autowired
    @Required
    public void setCfg(ConfigurationService cfg) {
        this.cfg = cfg;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void init() {
        String sessionName = this.cfg.getProperty("mail.session.name");
        if (null == sessionName) {
            sessionName = "Session";
        }
        try {
            InitialContext ctx = new InitialContext(null);
            this.session = (Session)ctx.lookup("java:comp/env/mail/" + sessionName);
        }
        catch (NamingException ex) {
            logger.warn("Couldn't get an email session from environment:  {}", (Object)ex.getMessage());
        }
        if (null != this.session) {
            logger.info("Email session retrieved from environment.");
        } else {
            String port;
            logger.info("Initializing an email session from configuration.");
            Properties props = new Properties();
            props.put("mail.transport.protocol", "smtp");
            String host = this.cfg.getProperty("mail.server");
            if (null != host) {
                props.put("mail.host", this.cfg.getProperty("mail.server"));
            }
            if (null != (port = this.cfg.getProperty("mail.server.port"))) {
                props.put("mail.smtp.port", port);
            }
            if (null == this.cfg.getProperty("mail.server.username")) {
                this.session = Session.getInstance((Properties)props);
            } else {
                props.put("mail.smtp.auth", "true");
                this.session = Session.getInstance((Properties)props, (Authenticator)this);
            }
            String extras = this.cfg.getProperty("mail.extraproperties");
            if (extras != null && !"".equals(extras.trim())) {
                String[] arguments;
                for (String argument : arguments = extras.split(",")) {
                    String key = argument.substring(0, argument.indexOf(61)).trim();
                    String value = argument.substring(argument.indexOf(61) + 1).trim();
                    props.put(key, value);
                }
            }
        }
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        if (null == this.cfg) {
            this.cfg = new DSpace().getConfigurationService();
        }
        return new PasswordAuthentication(this.cfg.getProperty("mail.server.username"), this.cfg.getProperty("mail.server.password"));
    }
}

