/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.sessions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.dspace.kernel.mixins.InitializedService;
import org.dspace.kernel.mixins.ShutdownService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.RequestService;
import org.dspace.services.SessionService;
import org.dspace.services.model.Request;
import org.dspace.services.model.RequestInterceptor;
import org.dspace.services.model.Session;
import org.dspace.services.sessions.model.HttpRequestImpl;
import org.dspace.services.sessions.model.InternalRequestImpl;
import org.dspace.utils.servicemanager.OrderedServiceComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public final class SessionRequestServiceImpl
implements SessionService,
RequestService,
InitializedService,
ShutdownService {
    private static Logger log = LoggerFactory.getLogger(SessionRequestServiceImpl.class);
    private ConfigurationService configurationService;
    private Map<String, RequestInterceptor> interceptorsMap = new HashMap<String, RequestInterceptor>();
    private RequestHolder requests = new RequestHolder();

    @Autowired
    @Required
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public void init() {
        log.info("init");
    }

    @Override
    public void shutdown() {
        log.info("shutdown");
        this.clear();
    }

    public void clear() {
        this.requests.clear();
        this.interceptorsMap.clear();
    }

    @Override
    public String startRequest() {
        return this.startRequest(new InternalRequestImpl());
    }

    @Override
    public String startRequest(ServletRequest request, ServletResponse response) {
        return this.startRequest(new HttpRequestImpl(request, response));
    }

    private String startRequest(Request req) {
        List<RequestInterceptor> interceptors = this.getInterceptors(false);
        for (RequestInterceptor requestInterceptor : interceptors) {
            if (requestInterceptor == null) continue;
            try {
                requestInterceptor.onStart(req.getRequestId(), req.getSession());
            }
            catch (RequestInterceptor.RequestInterruptionException e) {
                String message = "Request stopped from starting by exception from the interceptor (" + requestInterceptor + "): " + e.getMessage();
                log.warn(message);
                throw new RequestInterceptor.RequestInterruptionException(message, e);
            }
            catch (Exception e) {
                log.warn("Request interceptor (" + requestInterceptor + ") failed to execute on start (" + req.getRequestId() + "): " + e.getMessage());
            }
        }
        this.requests.setCurrent(req);
        return req.getRequestId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String endRequest(Exception failure) {
        String requestId = null;
        try {
            requestId = this.getCurrentRequestId();
            if (StringUtils.isEmpty((String)requestId)) {
                log.debug("Attempting to end a request when none currently exists");
            } else {
                this.endRequest(requestId, failure);
            }
        }
        finally {
            this.requests.removeCurrent();
        }
        return requestId;
    }

    private void endRequest(String requestId, Exception failure) {
        if (requestId != null) {
            Session session = null;
            Request req = this.requests.get(requestId);
            if (req != null) {
                session = req.getSession();
            }
            List<RequestInterceptor> interceptors = this.getInterceptors(true);
            for (RequestInterceptor requestInterceptor : interceptors) {
                if (requestInterceptor == null) continue;
                try {
                    requestInterceptor.onEnd(requestId, session, failure == null, failure);
                }
                catch (RequestInterceptor.RequestInterruptionException e) {
                    log.warn("Attempt to stop request from ending by an exception from the interceptor (" + requestInterceptor + "), cannot stop requests from ending though so request end continues, this may be an error: " + e.getMessage());
                }
                catch (Exception e) {
                    log.warn("Request interceptor (" + requestInterceptor + ") failed to execute on end (" + requestId + "): " + e.getMessage());
                }
            }
        }
    }

    private List<RequestInterceptor> getInterceptors(boolean reverse) {
        ArrayList<RequestInterceptor> l = new ArrayList<RequestInterceptor>(this.interceptorsMap.values());
        OrderedServiceComparator comparator = new OrderedServiceComparator();
        Collections.sort(l, comparator);
        if (reverse) {
            Collections.reverse(l);
        }
        return l;
    }

    @Override
    public void registerRequestInterceptor(RequestInterceptor interceptor) {
        if (interceptor == null) {
            throw new IllegalArgumentException("Cannot register an interceptor that is null");
        }
        if (interceptor.getOrder() <= 0) {
            throw new IllegalArgumentException("Interceptor ordering for RequestInterceptor's must be greater than 0");
        }
        String key = interceptor.getOrder() + ":" + interceptor.getClass().getName();
        this.interceptorsMap.put(key, interceptor);
    }

    @Override
    public Session getCurrentSession() {
        Request req = this.requests.getCurrent();
        if (req != null) {
            return req.getSession();
        }
        return null;
    }

    @Override
    public String getCurrentSessionId() {
        Session session;
        Request req = this.requests.getCurrent();
        if (req != null && (session = req.getSession()) != null) {
            return session.getSessionId();
        }
        return null;
    }

    @Override
    public String getCurrentUserId() {
        String userId = null;
        Session session = this.getCurrentSession();
        if (session != null) {
            userId = session.getUserId();
        }
        return userId;
    }

    @Override
    public String getCurrentRequestId() {
        Request req = this.requests.getCurrent();
        if (req != null) {
            return req.getRequestId();
        }
        return null;
    }

    @Override
    public Request getCurrentRequest() {
        return this.requests.getCurrent();
    }

    private class RequestHolder {
        Map<Long, Request> requestMap = new ConcurrentHashMap<Long, Request>();

        private RequestHolder() {
        }

        Request getCurrent() {
            return this.requestMap.get(Thread.currentThread().getId());
        }

        void setCurrent(Request req) {
            this.requestMap.put(Thread.currentThread().getId(), req);
        }

        void removeCurrent() {
            this.requestMap.remove(Thread.currentThread().getId());
        }

        Request get(String requestId) {
            if (!StringUtils.isEmpty((String)requestId)) {
                for (Request req : this.requestMap.values()) {
                    if (req == null || !requestId.equals(req.getRequestId())) continue;
                    return req;
                }
            }
            return null;
        }

        void remove(String requestId) {
            if (!StringUtils.isEmpty((String)requestId)) {
                for (Map.Entry<Long, Request> reqEntry : this.requestMap.entrySet()) {
                    if (reqEntry.getValue() == null || !requestId.equals(reqEntry.getValue().getRequestId())) continue;
                    this.requestMap.remove(reqEntry.getKey());
                }
            }
        }

        void clear() {
            for (Request request : this.requestMap.values()) {
                try {
                    SessionRequestServiceImpl.this.endRequest(request.getRequestId(), null);
                }
                catch (RuntimeException e) {
                    log.error("Runtime exception ending request", (Throwable)e);
                }
                catch (Exception e) {
                    log.error("Exception ending request", (Throwable)e);
                }
            }
            this.requestMap.clear();
        }
    }
}

