/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.sessions.model;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.services.model.Request;
import org.dspace.services.model.Session;
import org.dspace.services.sessions.model.AbstractRequestImpl;
import org.dspace.services.sessions.model.SessionImpl;

public final class HttpRequestImpl
extends AbstractRequestImpl
implements Request {
    private transient ServletRequest servletRequest = null;
    private transient ServletResponse servletResponse = null;
    private Session session = null;

    public HttpRequestImpl(ServletRequest request, ServletResponse response) {
        if (request == null || response == null) {
            throw new IllegalArgumentException("Cannot create a request without an http request or response");
        }
        this.servletRequest = request;
        this.servletResponse = response;
        this.session = this.servletRequest instanceof HttpServletRequest ? new SessionImpl((HttpServletRequest)this.servletRequest) : new SessionImpl();
    }

    @Override
    public ServletRequest getServletRequest() {
        return this.servletRequest;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        if (this.servletRequest instanceof HttpServletRequest) {
            return (HttpServletRequest)this.servletRequest;
        }
        return null;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public ServletResponse getServletResponse() {
        return this.servletResponse;
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        if (this.servletResponse instanceof HttpServletResponse) {
            return (HttpServletResponse)this.servletResponse;
        }
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        return this.servletRequest.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.servletRequest.setAttribute(name, o);
    }
}

