/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.sessions.model;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.dspace.services.model.Session;
import org.dspace.services.sessions.model.InternalHttpSession;

public final class SessionImpl
implements Session {
    public static final String SESSION_ID = "dspaceSessionId";
    public static final String USER_ID = "userId";
    public static final String USER_EID = "userEid";
    public static final String SERVER_ID = "serverId";
    public static final String HOST_IP = "originatingHostIP";
    public static final String HOST_NAME = "originatingHostName";
    private transient HttpSession httpSession;

    public SessionImpl(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Cannot create a session without an http request");
        }
        this.httpSession = request.getSession();
        this.setKeyAttribute(HOST_IP, request.getRemoteAddr());
        this.setKeyAttribute(HOST_NAME, request.getRemoteHost());
    }

    public SessionImpl() {
        this.httpSession = new InternalHttpSession();
        try {
            InetAddress i4 = Inet4Address.getLocalHost();
            this.setKeyAttribute(HOST_IP, i4.getHostAddress());
            this.setKeyAttribute(HOST_NAME, i4.getHostName());
        }
        catch (UnknownHostException e) {
            this.setKeyAttribute(HOST_IP, "10.0.0.1");
        }
    }

    public void setSessionId(String sessionId) {
        if (!this.isAttributeSet(SESSION_ID)) {
            if (SessionImpl.isBlank(sessionId)) {
                this.setKeyAttribute(SESSION_ID, this.httpSession.getId());
            } else {
                this.setKeyAttribute(SESSION_ID, sessionId);
            }
        }
    }

    public void setUserId(String userId, String userEid) {
        if (SessionImpl.isBlank(userId)) {
            this.removeKeyAttribute(USER_ID);
            this.removeKeyAttribute(USER_EID);
        } else {
            this.setKeyAttribute(USER_ID, userId);
            this.setKeyAttribute(USER_EID, userEid);
        }
    }

    public void setServerId(String serverId) {
        this.setKeyAttribute(SERVER_ID, serverId);
    }

    public boolean isIncomplete() {
        boolean complete = false;
        if (this.isAttributeSet(SERVER_ID) && this.isAttributeSet(SESSION_ID) && this.isAttributeSet(HOST_IP)) {
            complete = true;
        }
        return !complete;
    }

    public boolean isAttributeSet(String key) {
        return this.getKeyAtribute(key) != null;
    }

    public boolean isInvalidated() {
        boolean invalid = true;
        if (this.httpSession != null) {
            try {
                this.httpSession.getCreationTime();
                invalid = false;
            }
            catch (IllegalStateException e) {
                invalid = true;
            }
        } else {
            invalid = false;
        }
        return invalid;
    }

    protected boolean setKeyAttribute(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("session attribute key cannot be null");
        }
        boolean wasSet = false;
        if (!this.isInvalidated()) {
            if (SessionImpl.isBlank(value)) {
                this.httpSession.removeAttribute(key);
            } else {
                this.httpSession.setAttribute(key, (Object)value);
                wasSet = true;
            }
        }
        return wasSet;
    }

    protected String getKeyAtribute(String key) {
        if (key == null) {
            throw new IllegalArgumentException("session attribute key cannot be null");
        }
        String value = null;
        if (!this.isInvalidated()) {
            value = (String)this.httpSession.getAttribute(key);
        }
        return value;
    }

    protected void removeKeyAttribute(String key) {
        if (key == null) {
            throw new IllegalArgumentException("session attribute key cannot be null");
        }
        if (!this.isInvalidated()) {
            this.httpSession.removeAttribute(key);
        }
    }

    public boolean equals(Object obj) {
        boolean eq;
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof SessionImpl)) {
            return false;
        }
        SessionImpl castObj = (SessionImpl)obj;
        try {
            eq = this.getId().equals(castObj.getId());
        }
        catch (IllegalStateException e) {
            eq = false;
        }
        return eq;
    }

    public int hashCode() {
        String hashStr = this.getClass().getName() + ":" + this.httpSession.toString();
        return hashStr.hashCode();
    }

    public String toString() {
        String str = this.isInvalidated() ? "invalidated:" + this.httpSession.toString() + ":" + super.toString() : "active:" + this.getId() + ":user=" + this.getUserId() + "(" + this.getUserEID() + "):sid=" + this.getSessionId() + ":server=" + this.getServerId() + ":created=" + this.getCreationTime() + ":accessed=" + this.getLastAccessedTime() + ":maxInactiveSecs=" + this.getMaxInactiveInterval() + ":hostIP=" + this.getOriginatingHostIP() + ":hostName=" + this.getOriginatingHostName() + ":" + super.toString();
        return "Session:" + str;
    }

    @Override
    public String getAttribute(String key) {
        return this.getKeyAtribute(key);
    }

    @Override
    public void setAttribute(String key, String value) {
        this.setKeyAttribute(key, value);
    }

    public void removeAttribute(String name) {
        this.removeKeyAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (value != null && !(value instanceof String)) {
            throw new UnsupportedOperationException("Invalid session attribute (" + name + "," + value + "), Only strings can be stored in the session");
        }
        this.setKeyAttribute(name, (String)value);
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!this.isInvalidated()) {
            Enumeration names = this.httpSession.getAttributeNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = (String)this.httpSession.getAttribute(key);
                map.put(key, value);
            }
        }
        return map;
    }

    public Enumeration getAttributeNames() {
        return this.httpSession.getAttributeNames();
    }

    @Override
    public void clear() {
        if (!this.isInvalidated()) {
            Enumeration names = this.httpSession.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                this.httpSession.removeAttribute(name);
            }
        }
    }

    @Override
    public String getOriginatingHostIP() {
        return this.getKeyAtribute(HOST_IP);
    }

    @Override
    public String getOriginatingHostName() {
        return this.getKeyAtribute(HOST_NAME);
    }

    @Override
    public String getServerId() {
        return this.getKeyAtribute(SERVER_ID);
    }

    @Override
    public String getSessionId() {
        return this.getKeyAtribute(SESSION_ID);
    }

    @Override
    public String getUserEID() {
        return this.getKeyAtribute(USER_EID);
    }

    @Override
    public String getUserId() {
        return this.getKeyAtribute(USER_ID);
    }

    @Override
    public boolean isActive() {
        return !this.isInvalidated();
    }

    public long getCreationTime() {
        return this.httpSession.getCreationTime();
    }

    public String getId() {
        String id = null;
        id = this.isAttributeSet(SESSION_ID) ? this.getKeyAtribute(SESSION_ID) : this.httpSession.getId();
        return id;
    }

    public long getLastAccessedTime() {
        return this.httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.httpSession.getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int interval) {
        this.httpSession.setMaxInactiveInterval(interval);
    }

    public ServletContext getServletContext() {
        if (this.httpSession != null) {
            return this.httpSession.getServletContext();
        }
        throw new UnsupportedOperationException("No http session available for this operation");
    }

    public void invalidate() {
        if (!this.isInvalidated()) {
            this.httpSession.invalidate();
        }
    }

    public boolean isNew() {
        if (!this.isInvalidated()) {
            return this.httpSession.isNew();
        }
        return false;
    }

    public Object getValue(String name) {
        return this.getKeyAtribute(name);
    }

    public String[] getValueNames() {
        Set<String> keys = this.getAttributes().keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public HttpSessionContext getSessionContext() {
        if (this.httpSession != null) {
            return this.httpSession.getSessionContext();
        }
        throw new UnsupportedOperationException("No http session available for this operation");
    }

    public static boolean isBlank(String string) {
        return string == null || "".equals(string);
    }

    public static final class SessionLastAccessedComparator
    implements Comparator<Session>,
    Serializable {
        public static final long serialVersionUID = 1L;

        @Override
        public int compare(Session o1, Session o2) {
            try {
                Long lat1 = o1.getLastAccessedTime();
                Long lat2 = o2.getLastAccessedTime();
                return lat2.compareTo(lat1);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

