/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.core.ConfigurationManager;
import org.dspace.handle.HandleManager;
import org.dspace.sword.DSpaceATOMEntry;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.atom.Content;
import org.purl.sword.atom.ContentType;
import org.purl.sword.atom.InvalidMediaTypeException;
import org.purl.sword.atom.Link;
import org.purl.sword.atom.Rights;
import org.purl.sword.atom.Summary;
import org.purl.sword.atom.Title;

public class ItemEntryGenerator
extends DSpaceATOMEntry {
    private static Logger log = Logger.getLogger(ItemEntryGenerator.class);

    protected ItemEntryGenerator(SWORDService service) {
        super(service);
    }

    @Override
    protected void addCategories() {
        DCValue[] dcv = this.item.getMetadata("dc.subject.*");
        if (dcv != null) {
            for (int i = 0; i < dcv.length; ++i) {
                this.entry.addCategory(dcv[i].value);
            }
        }
    }

    @Override
    protected void addContentElement() throws DSpaceSWORDException {
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        try {
            if (!this.deposit.isNoOp()) {
                String handle = "";
                if (this.item.getHandle() != null) {
                    handle = this.item.getHandle();
                }
                if (handle != null && !"".equals(handle)) {
                    boolean keepOriginal = ConfigurationManager.getBooleanProperty((String)"sword.keep-original-package");
                    String swordBundle = ConfigurationManager.getProperty((String)"sword.bundle.name");
                    if (swordBundle == null || "".equals(swordBundle)) {
                        swordBundle = "SWORD";
                    }
                    if (keepOriginal) {
                        Content con = new Content();
                        Bundle[] bundles = this.item.getBundles(swordBundle);
                        if (bundles.length > 0) {
                            Bitstream[] bss = bundles[0].getBitstreams();
                            for (int i = 0; i < bss.length; ++i) {
                                BitstreamFormat bf = bss[i].getFormat();
                                String format = "application/octet-stream";
                                if (bf != null) {
                                    format = bf.getMIMEType();
                                }
                                con.setType(format);
                                String bsLink = urlManager.getBitstreamUrl(bss[i]);
                                con.setSource(bsLink);
                                this.entry.setContent(con);
                            }
                        }
                    } else {
                        Content content = new Content();
                        content.setType("text/html");
                        content.setSource(HandleManager.getCanonicalForm((String)handle));
                        this.entry.setContent(content);
                    }
                }
            }
        }
        catch (InvalidMediaTypeException e) {
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }

    @Override
    protected void addIdentifier() {
        if (!this.deposit.isNoOp()) {
            String handle = "";
            if (this.item.getHandle() != null) {
                handle = this.item.getHandle();
            }
            if (handle != null && !"".equals(handle)) {
                this.entry.setId(HandleManager.getCanonicalForm((String)handle));
                return;
            }
        }
        String cfg = ConfigurationManager.getProperty((String)"dspace.url");
        this.entry.setId(cfg);
    }

    @Override
    protected void addLinks() throws DSpaceSWORDException {
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        try {
            String handle = "";
            if (this.item.getHandle() == null) {
                return;
            }
            handle = this.item.getHandle();
            Bundle[] bundles = this.item.getBundles("ORIGINAL");
            for (int i = 0; i < bundles.length; ++i) {
                Bitstream[] bss = bundles[i].getBitstreams();
                for (int j = 0; j < bss.length; ++j) {
                    Link link = new Link();
                    String url = urlManager.getBitstreamUrl(bss[j]);
                    link.setHref(url);
                    link.setRel("part");
                    BitstreamFormat bsf = bss[j].getFormat();
                    if (bsf != null) {
                        link.setType(bsf.getMIMEType());
                    }
                    this.entry.addLink(link);
                }
            }
            Link splash = new Link();
            splash.setHref(HandleManager.getCanonicalForm((String)handle));
            splash.setRel("alternate");
            splash.setType("text/html");
            this.entry.addLink(splash);
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }

    @Override
    protected void addPublishDate() {
        DCValue[] dcv = this.item.getMetadata("dc.date.issued");
        if (dcv != null && dcv.length == 1) {
            this.entry.setPublished(dcv[0].value);
        }
    }

    @Override
    protected void addRights() throws DSpaceSWORDException {
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        try {
            String handle = this.item.getHandle();
            if (handle == null || "".equals(handle)) {
                return;
            }
            String base = ConfigurationManager.getProperty((String)"dspace.url");
            if (base == null) {
                return;
            }
            StringBuilder rightsString = new StringBuilder();
            Bundle[] bundles = this.item.getBundles("LICENSE");
            for (int i = 0; i < bundles.length; ++i) {
                Bitstream[] bss = bundles[i].getBitstreams();
                for (int j = 0; j < bss.length; ++j) {
                    String url = urlManager.getBitstreamUrl(bss[j]);
                    rightsString.append(url + " ");
                }
            }
            Rights rights = new Rights();
            rights.setContent(rightsString.toString());
            rights.setType(ContentType.TEXT);
            this.entry.setRights(rights);
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }

    @Override
    protected void addSummary() {
        DCValue[] dcv = this.item.getMetadata("dc.description.abstract");
        if (dcv != null) {
            for (int i = 0; i < dcv.length; ++i) {
                Summary summary = new Summary();
                summary.setContent(dcv[i].value);
                summary.setType(ContentType.TEXT);
                this.entry.setSummary(summary);
            }
        }
    }

    @Override
    protected void addTitle() {
        DCValue[] dcv = this.item.getMetadata("dc.title");
        if (dcv != null) {
            for (int i = 0; i < dcv.length; ++i) {
                Title title = new Title();
                title.setContent(dcv[i].value);
                title.setType(ContentType.TEXT);
                this.entry.setTitle(title);
            }
        }
    }

    @Override
    protected void addLastUpdatedDate() {
        String config = ConfigurationManager.getProperty((String)"sword.updated.field");
        DCValue[] dcv = this.item.getMetadata(config);
        if (dcv != null && dcv.length == 1) {
            DCDate dcd = new DCDate(dcv[0].value);
            this.entry.setUpdated(dcd.toString());
        }
    }
}

