/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import nu.xom.Element;
import org.apache.log4j.Logger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

public abstract class BasicContentElement
extends XmlElement
implements SwordElementInterface {
    private static Logger log = Logger.getLogger(BasicContentElement.class);

    public BasicContentElement(String prefix, String name, String namespaceUri) {
        super(prefix, name, namespaceUri);
    }

    public BasicContentElement(XmlName name) {
        super(name);
    }

    @Override
    public Element marshall() {
        Element element = new Element(this.getQualifiedName(), this.xmlName.getNamespace());
        this.marshallContent(element);
        return element;
    }

    protected abstract void marshallContent(Element var1);

    public SwordValidationInfo unmarshall(Element element, Properties validationProperties) throws UnmarshallException {
        ArrayList<SwordValidationInfo> attributeItems;
        ArrayList<SwordValidationInfo> validationItems;
        block8: {
            if (!this.isInstanceOf(element, this.xmlName)) {
                return this.handleIncorrectElement(element, validationProperties);
            }
            validationItems = new ArrayList<SwordValidationInfo>();
            attributeItems = new ArrayList<SwordValidationInfo>();
            try {
                this.processUnexpectedAttributes(element, attributeItems);
                int length = element.getChildCount();
                if (length > 0) {
                    try {
                        this.unmarshallContent(element);
                    }
                    catch (UnmarshallException ume) {
                        log.error((Object)("Error accessing the content of the " + this.xmlName.getQualifiedName() + "  element"));
                        if (validationProperties == null) {
                            throw ume;
                        }
                        SwordValidationInfo info = new SwordValidationInfo(this.xmlName, "There is an error with the value.", SwordValidationInfoType.ERROR);
                        info.setContentDescription(element.getValue());
                        validationItems.add(info);
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)("Unable to parse an element in " + this.getQualifiedName() + ": " + ex.getMessage()));
                if (validationProperties != null) break block8;
                throw new UnmarshallException("Unable to parse an element in " + this.getQualifiedName(), ex);
            }
        }
        SwordValidationInfo result = null;
        if (validationProperties != null) {
            result = this.validate(validationItems, attributeItems, validationProperties);
        }
        return result;
    }

    @Override
    public void unmarshall(Element element) throws UnmarshallException {
    }

    @Override
    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, null, validationContext);
    }

    protected SwordValidationInfo validate(List<SwordValidationInfo> existing, List<SwordValidationInfo> attributeItems, Properties validationContext) {
        SwordValidationInfo result = new SwordValidationInfo(this.xmlName);
        result.setContentDescription(this.getContentAsString());
        SwordValidationInfo contentResult = this.validateContent(validationContext);
        if (contentResult != null) {
            result.addValidationInfo(contentResult);
        }
        result.addUnmarshallValidationInfo(existing, attributeItems);
        return result;
    }

    protected abstract void unmarshallContent(Element var1) throws UnmarshallException;

    protected abstract SwordValidationInfo validateContent(Properties var1);

    protected abstract String getContentAsString();
}

