/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.ast;

import java.util.HashMap;
import java.util.Map;
import org.duelengine.duel.ast.AttributePair;
import org.duelengine.duel.ast.DuelNode;
import org.duelengine.duel.ast.ElementNode;
import org.duelengine.duel.ast.LiteralNode;

public class MetaElementNode
extends ElementNode {
    public static final String NAME = "meta";
    private static final Map<String, String> linkProperties = new HashMap<String, String>();

    public MetaElementNode(int index, int line, int column) {
        super(NAME, index, line, column);
    }

    public MetaElementNode(AttributePair[] attr, DuelNode[] children) {
        super(NAME, attr, children);
    }

    @Override
    public boolean isLinkAttribute(String name) {
        if ("content".equalsIgnoreCase(name) && this.hasAttributes()) {
            String property;
            String key = "name";
            DuelNode attr = this.getAttribute(key);
            if (attr == null && (attr = this.getAttribute(key = "property")) == null) {
                key = "itemprop";
                attr = this.getAttribute(key);
            }
            if (attr instanceof LiteralNode && (property = ((LiteralNode)attr).getValue()) != null && key.equalsIgnoreCase(linkProperties.get(property))) {
                return true;
            }
        }
        return super.isLinkAttribute(name);
    }

    static {
        linkProperties.put("og:url", "property");
        linkProperties.put("og:image", "property");
        linkProperties.put("og:image:url", "property");
        linkProperties.put("og:image:secure_url", "property");
        linkProperties.put("og:video", "property");
        linkProperties.put("og:video:url", "property");
        linkProperties.put("og:video:secure_url", "property");
        linkProperties.put("og:audio", "property");
        linkProperties.put("og:audio:url", "property");
        linkProperties.put("og:audio:secure_url", "property");
        linkProperties.put("image", "itemprop");
        linkProperties.put("twitter:image", "name");
        linkProperties.put("twitter:image:src", "name");
        linkProperties.put("twitter:image0", "name");
        linkProperties.put("twitter:image1", "name");
        linkProperties.put("twitter:image2", "name");
        linkProperties.put("twitter:image3", "name");
        linkProperties.put("twitter:player", "name");
        linkProperties.put("twitter:player:stream", "name");
    }
}

