/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import org.duelengine.duel.DuelData;
import org.duelengine.duel.codedom.CodeBinaryOperatorType;
import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeVisitor;

public class CodeBinaryOperatorExpression
extends CodeExpression {
    private CodeBinaryOperatorType operator;
    private CodeExpression left;
    private CodeExpression right;

    public CodeBinaryOperatorExpression() {
    }

    public CodeBinaryOperatorExpression(CodeBinaryOperatorType op, CodeExpression left, CodeExpression right) {
        this.operator = op;
        this.left = left;
        this.right = right;
    }

    public CodeBinaryOperatorType getOperator() {
        return this.operator;
    }

    public void setOperator(CodeBinaryOperatorType value) {
        this.operator = value;
    }

    public CodeExpression getRight() {
        return this.right;
    }

    public void setRight(CodeExpression value) {
        this.right = value;
    }

    public CodeExpression getLeft() {
        return this.left;
    }

    public void setLeft(CodeExpression value) {
        this.left = value;
    }

    @Override
    public Class<?> getResultType() {
        switch (this.operator) {
            case ADD: 
            case ADD_ASSIGN: 
            case SUBTRACT: 
            case SUBTRACT_ASSIGN: 
            case MULTIPLY: 
            case MULTIPLY_ASSIGN: 
            case DIVIDE: 
            case DIVIDE_ASSIGN: 
            case MODULUS: 
            case MODULUS_ASSIGN: 
            case SHIFT_LEFT: 
            case SHIFT_LEFT_ASSIGN: 
            case SHIFT_RIGHT: 
            case SHIFT_RIGHT_ASSIGN: 
            case USHIFT_RIGHT: 
            case USHIFT_RIGHT_ASSIGN: 
            case BITWISE_AND: 
            case BITWISE_AND_ASSIGN: 
            case BITWISE_OR: 
            case BITWISE_OR_ASSIGN: 
            case BITWISE_XOR: 
            case BITWISE_XOR_ASSIGN: {
                return Number.class;
            }
            case BOOLEAN_AND: 
            case BOOLEAN_OR: {
                if (this.left == null || !DuelData.isBoolean(this.left.getResultType()) || this.right == null || !DuelData.isBoolean(this.right.getResultType())) {
                    return Object.class;
                }
                return Boolean.class;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case IDENTITY_EQUALITY: 
            case IDENTITY_INEQUALITY: 
            case VALUE_EQUALITY: 
            case VALUE_INEQUALITY: {
                return Boolean.class;
            }
            case ASSIGN: {
                if (this.left != null && !this.left.getResultType().equals(Object.class)) {
                    return this.left.getResultType();
                }
                if (this.right != null) {
                    return this.right.getResultType();
                }
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public void visit(CodeVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.left != null) {
                this.left.visit(visitor);
            }
            if (this.right != null) {
                this.right.visit(visitor);
            }
        }
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodeBinaryOperatorExpression)) {
            return false;
        }
        CodeBinaryOperatorExpression that = (CodeBinaryOperatorExpression)arg;
        if (this.operator != that.operator) {
            return false;
        }
        if (this.left == null ? that.left != null : !this.left.equals(that.left)) {
            return false;
        }
        if (this.right == null ? that.right != null : !this.right.equals(that.right)) {
            return false;
        }
        return super.equals(arg);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = super.hashCode() * 1000003 + this.operator.hashCode();
        if (this.left != null) {
            hash = hash * 1000003 + this.left.hashCode();
        }
        if (this.right != null) {
            hash = hash * 1000003 + this.right.hashCode();
        }
        return hash;
    }
}

