/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import org.duelengine.duel.codedom.AccessModifierType;
import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeMember;
import org.duelengine.duel.codedom.CodeVisitor;

public class CodeField
extends CodeMember {
    private Class<?> type = Object.class;
    private CodeExpression initExpression;

    public CodeField() {
    }

    public CodeField(AccessModifierType access, Class<?> type, String fieldName) {
        this(access, type, fieldName, null);
    }

    public CodeField(AccessModifierType access, Class<?> type, String fieldName, CodeExpression initExpression) {
        super(access, fieldName);
        if (type != null) {
            this.type = type;
        }
        this.initExpression = initExpression;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> value) {
        this.type = value != null ? value : Object.class;
    }

    public CodeExpression getInitExpression() {
        return this.initExpression;
    }

    public void setInitExpression(CodeExpression value) {
        this.initExpression = value;
    }

    @Override
    public void visit(CodeVisitor visitor) {
        if (visitor.visit(this) && this.initExpression != null) {
            this.initExpression.visit(visitor);
        }
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodeField)) {
            return false;
        }
        CodeField that = (CodeField)arg;
        if (this.type == null ? that.type != null : !this.type.equals(that.type)) {
            return false;
        }
        if (this.initExpression == null ? that.initExpression != null : !this.initExpression.equals(that.initExpression)) {
            return false;
        }
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = super.hashCode();
        if (this.type != null) {
            hash = hash * 1000003 + this.type.hashCode();
        }
        if (this.initExpression != null) {
            hash = hash * 1000003 + this.initExpression.hashCode();
        }
        return hash;
    }
}

