/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codegen;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.duelengine.duel.DuelContext;
import org.duelengine.duel.DuelData;
import org.duelengine.duel.DuelPart;
import org.duelengine.duel.DuelView;
import org.duelengine.duel.HTMLFormatter;
import org.duelengine.duel.codedom.AccessModifierType;
import org.duelengine.duel.codedom.CodeBinaryOperatorExpression;
import org.duelengine.duel.codedom.CodeBinaryOperatorType;
import org.duelengine.duel.codedom.CodeConstructor;
import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeExpressionStatement;
import org.duelengine.duel.codedom.CodeMember;
import org.duelengine.duel.codedom.CodeMethod;
import org.duelengine.duel.codedom.CodeMethodInvokeExpression;
import org.duelengine.duel.codedom.CodeMethodReturnStatement;
import org.duelengine.duel.codedom.CodeObject;
import org.duelengine.duel.codedom.CodeParameterDeclarationExpression;
import org.duelengine.duel.codedom.CodePrimitiveExpression;
import org.duelengine.duel.codedom.CodeStatement;
import org.duelengine.duel.codedom.CodeStatementCollection;
import org.duelengine.duel.codedom.CodeThisReferenceExpression;
import org.duelengine.duel.codedom.CodeTypeDeclaration;
import org.duelengine.duel.codedom.CodeTypeReferenceExpression;
import org.duelengine.duel.codedom.CodeUnaryOperatorExpression;
import org.duelengine.duel.codedom.CodeUnaryOperatorType;
import org.duelengine.duel.codedom.CodeVariableDeclarationStatement;
import org.duelengine.duel.codedom.CodeVariableReferenceExpression;
import org.duelengine.duel.codedom.IdentifierScope;
import org.duelengine.duel.codegen.CodeGenSettings;

final class CodeDOMUtility {
    private CodeDOMUtility() {
    }

    public static CodeTypeDeclaration createViewType(String typeNS, String typeName, CodeMember ... members) {
        CodeTypeDeclaration viewType = new CodeTypeDeclaration(AccessModifierType.PUBLIC, typeNS, typeName, DuelView.class, new CodeMember[0]);
        viewType.add(CodeDOMUtility.createCtor(new CodeParameterDeclarationExpression[0]));
        viewType.add(CodeDOMUtility.createCtor(new CodeParameterDeclarationExpression(DuelPart.class, "parts", true)));
        if (members != null) {
            for (CodeMember member : members) {
                viewType.add(member);
            }
        }
        return viewType;
    }

    public static CodeTypeDeclaration createPartType(String typeName, CodeMember ... members) {
        CodeTypeDeclaration partType = new CodeTypeDeclaration(AccessModifierType.PRIVATE, null, typeName, DuelPart.class, new CodeMember[0]);
        if (members != null) {
            for (CodeMember member : members) {
                partType.add(member);
            }
        }
        return partType;
    }

    public static CodeConstructor createCtor(CodeParameterDeclarationExpression ... parameters) {
        CodeConstructor ctor = new CodeConstructor();
        ctor.setAccess(AccessModifierType.PUBLIC);
        for (CodeParameterDeclarationExpression parameter : parameters) {
            ctor.addParameter(parameter);
            ctor.getBaseCtorArgs().add(new CodeVariableReferenceExpression(parameter));
        }
        return ctor;
    }

    public static CodeVariableDeclarationStatement nextID(IdentifierScope scope) {
        return new CodeVariableDeclarationStatement(String.class, scope.nextIdent("id_"), new CodeMethodInvokeExpression(String.class, new CodeThisReferenceExpression(), "nextID", new CodeVariableReferenceExpression(DuelContext.class, "context")));
    }

    public static CodeStatement emitLiteralValue(String literal) {
        return CodeDOMUtility.emitExpression(new CodePrimitiveExpression(literal.length() == 1 ? Character.valueOf(literal.charAt(0)) : literal));
    }

    public static CodeStatement emitVarValue(CodeVariableDeclarationStatement localVar) {
        return CodeDOMUtility.emitExpression(new CodeVariableReferenceExpression(localVar));
    }

    public static CodeStatement emitExpressionSafe(CodeExpression expression, HTMLFormatter formatter, CodeGenSettings settings) {
        Class<?> exprType = expression.getResultType();
        if (Boolean.class.equals(exprType) || Number.class.isAssignableFrom(exprType) || exprType != null && exprType.isPrimitive() && !Character.TYPE.equals(exprType)) {
            return CodeDOMUtility.emitExpression(expression);
        }
        if (expression instanceof CodePrimitiveExpression) {
            try {
                Object value = ((CodePrimitiveExpression)expression).getValue();
                if (!(value instanceof Boolean) && !(value instanceof Number)) {
                    StringBuilder output = new StringBuilder();
                    formatter.writeLiteral((Appendable)output, DuelData.coerceString((Object)value), settings.getEncodeNonASCII());
                    value = output.toString();
                }
                expression = new CodePrimitiveExpression(value);
                return CodeDOMUtility.emitExpression(expression);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return new CodeExpressionStatement(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "htmlEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), expression));
    }

    public static CodeStatement emitExpression(CodeExpression expression) {
        return new CodeExpressionStatement(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "write", new CodeVariableReferenceExpression(DuelContext.class, "context"), expression));
    }

    public static CodeExpression inlineMethod(CodeMethod method) {
        List<CodeParameterDeclarationExpression> parameters = method.getParameters();
        if (parameters.size() != 5 || !DuelContext.class.equals(parameters.get(0).getType())) {
            return null;
        }
        CodeStatementCollection statements = method.getStatements();
        if (statements.size() != 1) {
            return null;
        }
        CodeStatement last = statements.getLastStatement();
        if (last instanceof CodeMethodReturnStatement) {
            return ((CodeMethodReturnStatement)last).getExpression();
        }
        return null;
    }

    public static boolean isBoolean(CodeExpression expression) {
        return DuelData.isBoolean(expression.getResultType());
    }

    public static boolean isNumber(CodeExpression expression) {
        return DuelData.isNumber(expression.getResultType());
    }

    public static boolean isString(CodeExpression expression) {
        return DuelData.isString(expression.getResultType());
    }

    public static CodeExpression ensureBoolean(CodeExpression expression) {
        if (CodeDOMUtility.isBoolean(expression)) {
            return expression;
        }
        return new CodeMethodInvokeExpression(Boolean.TYPE, new CodeTypeReferenceExpression(DuelData.class), "coerceBoolean", expression);
    }

    public static CodeExpression ensureNumber(CodeExpression expression) {
        if (CodeDOMUtility.isNumber(expression)) {
            return expression;
        }
        return new CodeMethodInvokeExpression(Double.TYPE, new CodeTypeReferenceExpression(DuelData.class), "coerceNumber", expression);
    }

    public static CodeExpression ensureString(CodeExpression expression) {
        if (CodeDOMUtility.isString(expression)) {
            return expression;
        }
        return new CodeMethodInvokeExpression(String.class, new CodeTypeReferenceExpression(DuelData.class), "coerceString", expression);
    }

    public static CodeExpression ensureCollection(CodeExpression expression) {
        if (List.class.equals(expression.getResultType())) {
            return expression;
        }
        return new CodeMethodInvokeExpression(Collection.class, new CodeTypeReferenceExpression(DuelData.class), "coerceCollection", expression);
    }

    public static CodeExpression ensureMap(CodeExpression expression) {
        if (Map.class.equals(expression.getResultType())) {
            return expression;
        }
        return new CodeMethodInvokeExpression(Map.class, new CodeTypeReferenceExpression(DuelData.class), "coerceMap", expression);
    }

    public static CodeExpression equal(CodeExpression a, CodeExpression b) {
        return new CodeMethodInvokeExpression(Boolean.TYPE, new CodeThisReferenceExpression(), "equal", a, b);
    }

    public static CodeExpression notEqual(CodeExpression a, CodeExpression b) {
        return new CodeUnaryOperatorExpression(CodeUnaryOperatorType.LOGICAL_NEGATION, CodeDOMUtility.equal(a, b));
    }

    public static CodeExpression coerceEqual(CodeExpression a, CodeExpression b) {
        return new CodeMethodInvokeExpression(Boolean.TYPE, new CodeThisReferenceExpression(), "coerceEqual", a, b);
    }

    public static CodeExpression coerceNotEqual(CodeExpression a, CodeExpression b) {
        return new CodeUnaryOperatorExpression(CodeUnaryOperatorType.LOGICAL_NEGATION, CodeDOMUtility.coerceEqual(a, b));
    }

    public static CodeExpression safePreIncrement(CodeExpression i) {
        return CodeDOMUtility.asAssignment(CodeBinaryOperatorType.ADD, i, CodeDOMUtility.ensureNumber(i), CodePrimitiveExpression.ONE);
    }

    public static CodeExpression safePreDecrement(CodeExpression i) {
        return CodeDOMUtility.asAssignment(CodeBinaryOperatorType.SUBTRACT, i, CodeDOMUtility.ensureNumber(i), CodePrimitiveExpression.ONE);
    }

    public static CodeExpression safePostIncrement(CodeExpression i) {
        return new CodeMethodInvokeExpression(Double.TYPE, new CodeThisReferenceExpression(), "echo", CodeDOMUtility.ensureNumber(i), CodeDOMUtility.asAssignment(CodeBinaryOperatorType.ADD, i, CodeDOMUtility.ensureNumber(i), CodePrimitiveExpression.ONE));
    }

    public static CodeExpression safePostDecrement(CodeExpression i) {
        return new CodeMethodInvokeExpression(Double.TYPE, new CodeThisReferenceExpression(), "echo", CodeDOMUtility.ensureNumber(i), CodeDOMUtility.asAssignment(CodeBinaryOperatorType.SUBTRACT, i, CodeDOMUtility.ensureNumber(i), CodePrimitiveExpression.ONE));
    }

    public static CodeExpression asAssignment(CodeBinaryOperatorType op, CodeExpression assign, CodeExpression left, CodeExpression right) {
        return new CodeBinaryOperatorExpression(CodeBinaryOperatorType.ASSIGN, assign, new CodeBinaryOperatorExpression(op, left, right).withParens()).withParens();
    }

    public static CodeExpression ensureType(Class<?> varType, CodeExpression expr) {
        Class<?> valueType = expr.getResultType();
        if (varType.isAssignableFrom(valueType)) {
            return expr;
        }
        if (DuelData.isNumber(varType)) {
            return CodeDOMUtility.ensureNumber(expr);
        }
        if (DuelData.isString(varType)) {
            return CodeDOMUtility.ensureString(expr);
        }
        if (DuelData.isBoolean(varType)) {
            return CodeDOMUtility.ensureBoolean(expr);
        }
        return expr;
    }

    public static Class<?> toPrimitive(Class<?> exprType) {
        if (exprType.isPrimitive() || Number.class.isAssignableFrom(exprType) || Boolean.class.isAssignableFrom(exprType)) {
            return exprType;
        }
        return String.class;
    }

    public static CodeExpression lookupExtraVar(String ident) {
        return new CodeMethodInvokeExpression(Object.class, new CodeThisReferenceExpression(), "getExtra", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodePrimitiveExpression(ident));
    }

    public static CodeObject translateMethodCall(Class<?> returnType, CodeExpression target, String methodName, CodeExpression ... args) {
        if ("toString".equals(methodName)) {
            return CodeDOMUtility.ensureString(target);
        }
        if ("substring".equals(methodName)) {
            return new CodeMethodInvokeExpression(String.class, CodeDOMUtility.ensureString(target), "substring", args);
        }
        if ("substr".equals(methodName)) {
            if (args.length > 1) {
                args[1] = new CodeBinaryOperatorExpression(CodeBinaryOperatorType.ADD, args[0], args[1]);
            }
            return new CodeMethodInvokeExpression(String.class, CodeDOMUtility.ensureString(target), "substring", args);
        }
        return null;
    }
}

