/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.duelengine.duel.DuelContext;
import org.duelengine.duel.DuelData;
import org.duelengine.duel.JSUtility;
import org.duelengine.duel.codedom.AccessModifierType;
import org.duelengine.duel.codedom.CodeArrayCreateExpression;
import org.duelengine.duel.codedom.CodeBinaryOperatorExpression;
import org.duelengine.duel.codedom.CodeBinaryOperatorType;
import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeExpressionStatement;
import org.duelengine.duel.codedom.CodeIterationStatement;
import org.duelengine.duel.codedom.CodeMember;
import org.duelengine.duel.codedom.CodeMethod;
import org.duelengine.duel.codedom.CodeMethodInvokeExpression;
import org.duelengine.duel.codedom.CodeMethodReturnStatement;
import org.duelengine.duel.codedom.CodeObject;
import org.duelengine.duel.codedom.CodePrimitiveExpression;
import org.duelengine.duel.codedom.CodePropertyReferenceExpression;
import org.duelengine.duel.codedom.CodeStatement;
import org.duelengine.duel.codedom.CodeStatementBlock;
import org.duelengine.duel.codedom.CodeTernaryOperatorExpression;
import org.duelengine.duel.codedom.CodeTypeDeclaration;
import org.duelengine.duel.codedom.CodeTypeReferenceExpression;
import org.duelengine.duel.codedom.CodeUnaryOperatorExpression;
import org.duelengine.duel.codedom.CodeUnaryOperatorType;
import org.duelengine.duel.codedom.CodeVariableCompoundDeclarationStatement;
import org.duelengine.duel.codedom.CodeVariableDeclarationStatement;
import org.duelengine.duel.codedom.CodeVariableReferenceExpression;
import org.duelengine.duel.codedom.IdentifierScope;
import org.duelengine.duel.codedom.ScriptExpression;
import org.duelengine.duel.codedom.ScriptVariableReferenceExpression;
import org.duelengine.duel.codegen.CodeDOMUtility;
import org.duelengine.duel.codegen.ScriptTranslationException;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NewExpression;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.UnaryExpression;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;

public class ScriptTranslator
implements ErrorReporter {
    private final IdentifierScope scope;
    private Set<String> extraRefs;
    private boolean extraAssign;

    public ScriptTranslator() {
        this(new CodeTypeDeclaration());
    }

    public ScriptTranslator(IdentifierScope identScope) {
        if (identScope == null) {
            throw new NullPointerException("identScope");
        }
        this.scope = identScope;
    }

    public Set<String> getExtraRefs() {
        if (this.extraRefs == null) {
            return Collections.emptySet();
        }
        return this.extraRefs;
    }

    public boolean hasExtraAssign() {
        return this.extraAssign;
    }

    public List<CodeMember> translate(String jsSource) {
        this.extraRefs = null;
        this.extraAssign = false;
        String jsFilename = "anonymous.js";
        ScriptTranslator errorReporter = this;
        Context cx = Context.enter();
        cx.setLanguageVersion(150);
        CompilerEnvirons compEnv = new CompilerEnvirons();
        compEnv.initFromContext(cx);
        Parser parser = new Parser(compEnv, (ErrorReporter)errorReporter);
        AstRoot root = null;
        try {
            root = parser.parse(jsSource, jsFilename, 1);
        }
        catch (EvaluatorException ex) {
            String message = ex.getMessage();
            if (message == null) {
                message = ex.toString();
            }
            throw new ScriptTranslationException(message, ex);
        }
        finally {
            Context.exit();
        }
        if (root == null) {
            return null;
        }
        return this.visitRoot(root);
    }

    private CodeStatement visitStatement(AstNode node) {
        CodeObject value = this.visit(node);
        if (value instanceof CodeExpression) {
            return new CodeExpressionStatement((CodeExpression)value);
        }
        if (value != null && !(value instanceof CodeStatement)) {
            throw new ScriptTranslationException("Expected a statement: " + value.getClass(), node);
        }
        return (CodeStatement)value;
    }

    private CodeExpression visitExpression(AstNode node) {
        CodeObject value = this.visit(node);
        if (value instanceof CodeExpressionStatement) {
            return ((CodeExpressionStatement)value).getExpression();
        }
        if (value != null && !(value instanceof CodeExpression)) {
            throw new ScriptTranslationException("Expected an expression: " + value.getClass(), node);
        }
        return (CodeExpression)value;
    }

    private CodeExpression[] visitExpressionList(List<AstNode> nodes) {
        int length = nodes.size();
        if (length < 1) {
            return null;
        }
        CodeExpression[] expressions = new CodeExpression[length];
        for (int i = 0; i < length; ++i) {
            expressions[i] = this.visitExpression(nodes.get(i));
        }
        return expressions;
    }

    private CodeObject visit(AstNode node) throws IllegalArgumentException {
        if (node == null) {
            return null;
        }
        int tokenType = node.getType();
        switch (tokenType) {
            case 109: {
                return this.visitFunction((FunctionNode)node);
            }
            case 129: {
                if (node instanceof Block) {
                    return this.visitBlock((Block)node);
                }
                if (node instanceof Scope) {
                    return this.visitScope((Scope)node);
                }
                throw new ScriptTranslationException("Unexpected block token (" + node.getClass() + "):\n" + node.debugPrint(), node);
            }
            case 33: {
                return this.visitProperty((PropertyGet)node);
            }
            case 36: {
                return this.visitProperty((ElementGet)node);
            }
            case 4: {
                return this.visitReturn((ReturnStatement)node);
            }
            case 39: {
                return this.visitVarRef((Name)node, false);
            }
            case 87: {
                CodeExpression expr = this.visitExpression(((ParenthesizedExpression)node).getExpression());
                if (expr != null) {
                    expr.withParens();
                }
                return expr;
            }
            case 41: {
                return new CodePrimitiveExpression(((StringLiteral)node).getValue());
            }
            case 40: {
                double number = ((NumberLiteral)node).getNumber();
                if (number == (double)((int)number)) {
                    return new CodePrimitiveExpression((int)number);
                }
                if (number == (double)((long)number)) {
                    return new CodePrimitiveExpression((long)number);
                }
                return new CodePrimitiveExpression(number);
            }
            case 44: {
                return CodePrimitiveExpression.FALSE;
            }
            case 45: {
                return CodePrimitiveExpression.TRUE;
            }
            case 42: {
                return CodePrimitiveExpression.NULL;
            }
            case 119: {
                return this.visitForLoop((ForLoop)node);
            }
            case 122: {
                return this.visitVarDecl((VariableDeclaration)node);
            }
            case 65: {
                return this.visitArrayLiteral((ArrayLiteral)node);
            }
            case 66: {
                return this.visitObjectLiteral((ObjectLiteral)node);
            }
            case 38: {
                return this.visitFunctionCall((FunctionCall)node);
            }
            case 102: {
                return this.visitTernary((ConditionalExpression)node);
            }
            case 30: {
                return this.visitNew((NewExpression)node);
            }
            case 133: {
                ExpressionStatement voidExpr = (ExpressionStatement)node;
                if (voidExpr.hasSideEffects()) {
                    // empty if block
                }
                return this.visit(voidExpr.getExpression());
            }
            case 52: {
                return this.visitIn((InfixExpression)node);
            }
            case 53: {
                return this.visitInstanceOf((InfixExpression)node);
            }
            case 32: {
                return this.visitTypeOf((UnaryExpression)node);
            }
            case 43: 
            case 63: {
                throw new ScriptTranslationException("'this' not legal in binding expressions", node);
            }
            case 2: 
            case 3: {
                throw new ScriptTranslationException("'with' not legal in binding expressions", node);
            }
        }
        CodeBinaryOperatorType binary = this.mapBinaryOperator(tokenType);
        if (binary != CodeBinaryOperatorType.NONE) {
            return this.visitBinaryOp((InfixExpression)node, binary);
        }
        CodeUnaryOperatorType unary = this.mapUnaryOperator(tokenType);
        if (unary != CodeUnaryOperatorType.NONE) {
            return this.visitUnaryOp((UnaryExpression)node, unary);
        }
        throw new ScriptTranslationException("Token not yet supported (" + node.getClass() + "):\n" + node.debugPrint(), node);
    }

    private CodeObject visitProperty(ElementGet node) {
        CodeExpression target = this.visitExpression(node.getTarget());
        CodeExpression property = this.visitExpression(node.getElement());
        return new CodePropertyReferenceExpression(target, property);
    }

    private CodeObject visitProperty(PropertyGet node) {
        CodeExpression target = this.visitExpression(node.getTarget());
        CodePrimitiveExpression property = new CodePrimitiveExpression(node.getProperty().getIdentifier());
        return new CodePropertyReferenceExpression(target, property);
    }

    private CodeExpression visitIn(InfixExpression node) {
        CodeExpression key = this.visitExpression(node.getLeft());
        CodeExpression target = this.visitExpression(node.getRight());
        return new CodeMethodInvokeExpression(Boolean.class, new CodeTypeReferenceExpression(DuelData.class), "containsKey", target, key);
    }

    private CodeExpression visitInstanceOf(InfixExpression node) {
        String method;
        CodeExpression target = this.visitExpression(node.getLeft());
        AstNode type = node.getRight();
        if (!(type instanceof Name)) {
            throw new ScriptTranslationException("Unexpected type expression (" + type.getClass() + ")", (AstNode)node);
        }
        String typeIdent = ((Name)type).getIdentifier();
        if ("Array".equals(typeIdent)) {
            method = "isArray";
        } else if ("Date".equals(typeIdent)) {
            method = "isDate";
        } else {
            throw new ScriptTranslationException("Translation for 'instanceof' token currently only supports Array and Date (" + typeIdent + ")", (AstNode)node);
        }
        return new CodeTernaryOperatorExpression(new CodeBinaryOperatorExpression(CodeBinaryOperatorType.IDENTITY_EQUALITY, target, CodePrimitiveExpression.NULL).withParens(), CodePrimitiveExpression.FALSE, new CodeMethodInvokeExpression(Boolean.class, new CodeTypeReferenceExpression(DuelData.class), method, new CodeMethodInvokeExpression(Class.class, target, "getClass", new CodeExpression[0])));
    }

    private CodeExpression visitTypeOf(UnaryExpression node) {
        CodeExpression operand = this.visitExpression(node.getOperand());
        return new CodeMethodInvokeExpression(String.class, new CodeTypeReferenceExpression(DuelData.class), "typeOf", operand);
    }

    private CodeExpression visitBinaryOp(InfixExpression node, CodeBinaryOperatorType operator) {
        CodeExpression left = this.visitExpression(node.getLeft());
        CodeExpression right = this.visitExpression(node.getRight());
        return new CodeBinaryOperatorExpression(operator, left, right);
    }

    private CodeBinaryOperatorType mapBinaryOperator(int tokenType) {
        switch (tokenType) {
            case 90: {
                return CodeBinaryOperatorType.ASSIGN;
            }
            case 21: {
                return CodeBinaryOperatorType.ADD;
            }
            case 97: {
                return CodeBinaryOperatorType.ADD_ASSIGN;
            }
            case 22: {
                return CodeBinaryOperatorType.SUBTRACT;
            }
            case 98: {
                return CodeBinaryOperatorType.SUBTRACT_ASSIGN;
            }
            case 23: {
                return CodeBinaryOperatorType.MULTIPLY;
            }
            case 99: {
                return CodeBinaryOperatorType.MULTIPLY_ASSIGN;
            }
            case 24: {
                return CodeBinaryOperatorType.DIVIDE;
            }
            case 100: {
                return CodeBinaryOperatorType.DIVIDE_ASSIGN;
            }
            case 25: {
                return CodeBinaryOperatorType.MODULUS;
            }
            case 101: {
                return CodeBinaryOperatorType.MODULUS_ASSIGN;
            }
            case 9: {
                return CodeBinaryOperatorType.BITWISE_OR;
            }
            case 91: {
                return CodeBinaryOperatorType.BITWISE_OR_ASSIGN;
            }
            case 11: {
                return CodeBinaryOperatorType.BITWISE_AND;
            }
            case 93: {
                return CodeBinaryOperatorType.BITWISE_AND_ASSIGN;
            }
            case 10: {
                return CodeBinaryOperatorType.BITWISE_XOR;
            }
            case 92: {
                return CodeBinaryOperatorType.BITWISE_XOR_ASSIGN;
            }
            case 18: {
                return CodeBinaryOperatorType.SHIFT_LEFT;
            }
            case 94: {
                return CodeBinaryOperatorType.SHIFT_LEFT_ASSIGN;
            }
            case 19: {
                return CodeBinaryOperatorType.SHIFT_RIGHT;
            }
            case 95: {
                return CodeBinaryOperatorType.SHIFT_RIGHT_ASSIGN;
            }
            case 20: {
                return CodeBinaryOperatorType.USHIFT_RIGHT;
            }
            case 96: {
                return CodeBinaryOperatorType.USHIFT_RIGHT_ASSIGN;
            }
            case 104: {
                return CodeBinaryOperatorType.BOOLEAN_OR;
            }
            case 105: {
                return CodeBinaryOperatorType.BOOLEAN_AND;
            }
            case 14: {
                return CodeBinaryOperatorType.LESS_THAN;
            }
            case 15: {
                return CodeBinaryOperatorType.LESS_THAN_OR_EQUAL;
            }
            case 16: {
                return CodeBinaryOperatorType.GREATER_THAN;
            }
            case 17: {
                return CodeBinaryOperatorType.GREATER_THAN_OR_EQUAL;
            }
            case 12: {
                return CodeBinaryOperatorType.VALUE_EQUALITY;
            }
            case 13: {
                return CodeBinaryOperatorType.VALUE_INEQUALITY;
            }
            case 46: {
                return CodeBinaryOperatorType.IDENTITY_EQUALITY;
            }
            case 47: {
                return CodeBinaryOperatorType.IDENTITY_INEQUALITY;
            }
        }
        return CodeBinaryOperatorType.NONE;
    }

    private CodeExpression visitUnaryOp(UnaryExpression node, CodeUnaryOperatorType operator) {
        if (node.isPostfix()) {
            switch (operator) {
                case PRE_DECREMENT: {
                    operator = CodeUnaryOperatorType.POST_DECREMENT;
                    break;
                }
                case PRE_INCREMENT: {
                    operator = CodeUnaryOperatorType.POST_INCREMENT;
                    break;
                }
            }
        }
        CodeExpression operand = this.visitExpression(node.getOperand());
        return new CodeUnaryOperatorExpression(operator, operand);
    }

    private CodeUnaryOperatorType mapUnaryOperator(int tokenType) {
        switch (tokenType) {
            case 26: {
                return CodeUnaryOperatorType.LOGICAL_NEGATION;
            }
            case 29: {
                return CodeUnaryOperatorType.NEGATION;
            }
            case 28: {
                return CodeUnaryOperatorType.POSITIVE;
            }
            case 27: {
                return CodeUnaryOperatorType.BITWISE_NEGATION;
            }
            case 106: {
                return CodeUnaryOperatorType.PRE_INCREMENT;
            }
            case 107: {
                return CodeUnaryOperatorType.PRE_DECREMENT;
            }
        }
        return CodeUnaryOperatorType.NONE;
    }

    private CodeObject visitTernary(ConditionalExpression node) {
        CodeExpression testExpr = this.visitExpression(node.getTestExpression());
        CodeExpression trueExpr = this.visitExpression(node.getTrueExpression());
        CodeExpression falseExpr = this.visitExpression(node.getFalseExpression());
        return new CodeTernaryOperatorExpression(testExpr, trueExpr, falseExpr);
    }

    private CodeObject visitVarDecl(VariableDeclaration node) {
        CodeVariableCompoundDeclarationStatement vars = new CodeVariableCompoundDeclarationStatement();
        for (VariableInitializer init : node.getVariables()) {
            AstNode nameNode = init.getTarget();
            if (!(nameNode instanceof Name)) {
                throw new ScriptTranslationException("Unexpected VAR node type (" + nameNode.getClass() + ")", (AstNode)node);
            }
            CodeObject target = this.visitVarRef((Name)nameNode, true);
            if (!(target instanceof CodeVariableReferenceExpression)) {
                throw new ScriptTranslationException("Unexpected VAR type (" + target.getClass() + ")", (AstNode)node);
            }
            CodeVariableReferenceExpression varRef = (CodeVariableReferenceExpression)target;
            CodeVariableDeclarationStatement decl = new CodeVariableDeclarationStatement(varRef.getResultType(), varRef.getIdent(), this.visitExpression(init.getInitializer()));
            vars.addVar(decl);
        }
        if (vars.getVars().size() == 1) {
            return vars.getVars().get(0);
        }
        return vars;
    }

    private CodeObject visitVarRef(Name node, boolean declaration) {
        String ident = node.getIdentifier();
        if (JSUtility.isGlobalIdent((String)ident)) {
            if ("undefined".equals(ident)) {
                return ScriptExpression.UNDEFINED;
            }
            if ("NaN".equals(ident)) {
                return new CodePrimitiveExpression(Double.NaN);
            }
            if ("Infinity".equals(ident)) {
                return new CodePrimitiveExpression(Double.POSITIVE_INFINITY);
            }
        } else {
            if ("data".equals(ident)) {
                return new CodeVariableReferenceExpression(Object.class, "data");
            }
            if ("index".equals(ident) || "count".equals(ident)) {
                return new CodeVariableReferenceExpression(Integer.TYPE, ident);
            }
            if ("key".equals(ident)) {
                return new CodeVariableReferenceExpression(String.class, ident);
            }
            if (declaration || this.scope.isLocalIdent(ident)) {
                ident = this.scope.uniqueIdent(ident);
                return new CodeVariableReferenceExpression(Object.class, ident);
            }
        }
        if (node.getParent().getType() != 90 || ((InfixExpression)node.getParent()).getLeft() != node) {
            if (this.extraRefs == null) {
                this.extraRefs = new HashSet<String>();
            }
            this.extraRefs.add(ident);
        } else {
            this.extraAssign = true;
        }
        return new ScriptVariableReferenceExpression(ident);
    }

    private CodeObject visitForLoop(ForLoop node) {
        CodeIterationStatement loop = new CodeIterationStatement(this.visitStatement(node.getInitializer()), this.visitExpression(node.getCondition()), this.visitStatement(node.getIncrement()), new CodeStatement[0]);
        CodeObject body = this.visit(node.getBody());
        if (!(body instanceof CodeStatementBlock)) {
            throw new ScriptTranslationException("Expected statement block (" + body.getClass() + ")", node.getBody());
        }
        loop.getStatements().addAll((CodeStatementBlock)body);
        return loop;
    }

    private CodeMethod visitFunction(FunctionNode node) throws IllegalArgumentException {
        CodeMethod method = new CodeMethod(AccessModifierType.PRIVATE, Object.class, this.scope.nextIdent("code_"), null, new CodeStatement[0]);
        if (node.depth() != 1) {
            throw new ScriptTranslationException("Nested functions not yet supported.", (AstNode)node);
        }
        method.addParameter(DuelContext.class, "context");
        method.addParameter(Object.class, "data");
        method.addParameter(Integer.TYPE, "index");
        method.addParameter(Integer.TYPE, "count");
        method.addParameter(String.class, "key");
        CodeObject body = this.visit(node.getBody());
        if (body instanceof CodeStatementBlock) {
            method.getStatements().addAll((CodeStatementBlock)body);
        } else if (body instanceof CodeStatement) {
            method.getStatements().add((CodeStatement)body);
        } else if (body instanceof CodeExpression) {
            method.getStatements().add((CodeExpression)body);
        } else if (body != null) {
            throw new ScriptTranslationException("Unexpected function body: " + body.getClass(), node.getBody());
        }
        if (node.depth() == 1 && !(method.getStatements().getLastStatement() instanceof CodeMethodReturnStatement)) {
            method.getStatements().add(new CodeMethodReturnStatement(ScriptExpression.UNDEFINED));
        }
        return method;
    }

    private CodeMethodReturnStatement visitReturn(ReturnStatement node) {
        CodeExpression value = this.visitExpression(node.getReturnValue());
        return new CodeMethodReturnStatement(value != null ? value : ScriptExpression.UNDEFINED);
    }

    private CodeObject visitFunctionCall(FunctionCall node) {
        CodeExpression target = this.visitExpression(node.getTarget());
        if (!(target instanceof CodePropertyReferenceExpression)) {
            throw new ScriptTranslationException("Unsupported function call (" + node.getClass() + "):\n" + node.debugPrint(), node.getTarget());
        }
        CodePropertyReferenceExpression propertyRef = (CodePropertyReferenceExpression)target;
        CodeExpression nameExpr = propertyRef.getPropertyName();
        if (!(nameExpr instanceof CodePrimitiveExpression)) {
            throw new ScriptTranslationException("Unsupported function call (" + node.getClass() + "):\n" + node.debugPrint(), node.getTarget());
        }
        String methodName = DuelData.coerceString((Object)((CodePrimitiveExpression)nameExpr).getValue());
        CodeExpression[] args = this.visitExpressionList(node.getArguments());
        CodeObject methodCall = CodeDOMUtility.translateMethodCall(propertyRef.getResultType(), propertyRef.getTarget(), methodName, args);
        if (methodCall == null) {
            throw new ScriptTranslationException("Unsupported function call (" + node.getClass() + "):\n" + node.debugPrint(), node.getTarget());
        }
        return methodCall;
    }

    private CodeObject visitNew(NewExpression node) {
        String ident;
        AstNode target = node.getTarget();
        if (target instanceof Name && "Array".equals(ident = ((Name)target).getIdentifier())) {
            return this.visitArrayCtor(node);
        }
        throw new ScriptTranslationException("Create object type not yet supported (" + node.getClass() + "):\n" + node.debugPrint(), (AstNode)node);
    }

    private CodeObject visitObjectLiteral(ObjectLiteral node) {
        List properties = node.getElements();
        int length = properties.size();
        CodeExpression[] initializers = new CodeExpression[length * 2];
        for (int i = 0; i < length; ++i) {
            ObjectProperty property = (ObjectProperty)properties.get(i);
            AstNode key = property.getLeft();
            initializers[i * 2] = key.getType() == 39 ? new CodePrimitiveExpression(((Name)key).getIdentifier()) : this.visitExpression(key);
            initializers[i * 2 + 1] = this.visitExpression(property.getRight());
        }
        return new CodeMethodInvokeExpression(Map.class, new CodeTypeReferenceExpression(DuelData.class), "asMap", initializers);
    }

    private CodeObject visitArrayLiteral(ArrayLiteral node) {
        CodeExpression[] initializers = this.visitExpressionList(node.getElements());
        return new CodeArrayCreateExpression(Object.class, initializers);
    }

    private CodeObject visitArrayCtor(NewExpression node) {
        CodePrimitiveExpression arg;
        CodeExpression[] initializers = this.visitExpressionList(node.getArguments());
        if (initializers != null && initializers.length == 1 && initializers[0] instanceof CodePrimitiveExpression && CodeDOMUtility.isNumber(arg = (CodePrimitiveExpression)initializers[0])) {
            int size = ((Number)arg.getValue()).intValue();
            return new CodeArrayCreateExpression(Object.class, size);
        }
        return new CodeArrayCreateExpression(Object.class, initializers);
    }

    private CodeObject visitScope(Scope scope) {
        CodeStatementBlock statements = new CodeStatementBlock();
        for (Node node : scope) {
            CodeObject value = this.visit((AstNode)node);
            if (value == null) continue;
            if (value instanceof CodeStatement) {
                statements.add((CodeStatement)value);
                continue;
            }
            if (value instanceof CodeExpression) {
                statements.add((CodeExpression)value);
                continue;
            }
            if (value instanceof CodeStatementBlock) {
                statements.addAll((CodeStatementBlock)value);
                continue;
            }
            throw new ScriptTranslationException("Unexpected statement value: " + value.getClass(), (AstNode)node);
        }
        return statements;
    }

    private CodeStatementBlock visitBlock(Block block) {
        CodeStatementBlock statements = new CodeStatementBlock();
        for (Node node : block) {
            CodeObject value = this.visit((AstNode)node);
            if (value == null) continue;
            if (value instanceof CodeStatement) {
                statements.add((CodeStatement)value);
                continue;
            }
            if (value instanceof CodeExpression) {
                statements.add((CodeExpression)value);
                continue;
            }
            if (value instanceof CodeStatementBlock) {
                statements.addAll((CodeStatementBlock)value);
                continue;
            }
            throw new ScriptTranslationException("Unexpected statement value: " + value.getClass(), (AstNode)node);
        }
        return statements;
    }

    private List<CodeMember> visitRoot(AstRoot root) {
        ArrayList<CodeMember> members = new ArrayList<CodeMember>();
        for (Node node : root) {
            CodeObject member = this.visit((AstNode)node);
            if (member == null) continue;
            if (member instanceof CodeMember) {
                members.add((CodeMember)member);
                continue;
            }
            throw new ScriptTranslationException("Unexpected member: " + member.getClass(), (AstNode)node);
        }
        return members;
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        throw this.runtimeError(message, sourceName, line, lineSource, lineOffset);
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }
}

