/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.metrics.internal.cloudwatch.BlockingRequestBuilder;
import com.amazonaws.metrics.internal.cloudwatch.CloudWatchMetricConfig;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.util.VersionInfoUtils;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MetricUploaderThread
extends Thread {
    private static final String USER_AGENT = MetricUploaderThread.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String THREAD_NAME = "java-sdk-metric-uploader";
    private volatile boolean cancelled;
    private final AmazonCloudWatchClient cloudwatchClient;
    private final Log log = LogFactory.getLog(this.getClass());
    private final BlockingRequestBuilder qIterator;

    MetricUploaderThread(CloudWatchMetricConfig config, BlockingQueue<MetricDatum> queue) {
        this(config, queue, config.getCredentialsProvider() == null ? new AmazonCloudWatchClient() : new AmazonCloudWatchClient(config.getCredentialsProvider()));
    }

    MetricUploaderThread(CloudWatchMetricConfig config, BlockingQueue<MetricDatum> queue, AmazonCloudWatchClient client) {
        super(THREAD_NAME);
        if (config == null || queue == null) {
            throw new IllegalArgumentException();
        }
        this.cloudwatchClient = client;
        this.qIterator = new BlockingRequestBuilder(config, queue);
        String endpoint = config.getCloudWatchEndPoint();
        if (endpoint != null) {
            this.cloudwatchClient.setEndpoint(endpoint);
        }
        this.setPriority(1);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.cancelled) {
            try {
                Iterable<PutMetricDataRequest> requests = this.qIterator.nextUploadUnits();
                for (PutMetricDataRequest req : requests) {
                    this.appendUserAgent(req);
                    this.log.debug(req);
                    this.cloudwatchClient.putMetricData(req);
                    Thread.yield();
                }
            }
            catch (InterruptedException e) {
                if (this.cancelled) continue;
                this.log.debug("Unexpected interruption ignored");
            }
            catch (Throwable t) {
                this.log.warn("Unexpected condition; soldier on", t);
                Thread.yield();
            }
        }
    }

    void cancel() {
        this.cancelled = true;
    }

    public AmazonCloudWatchClient getCloudwatchClient() {
        return this.cloudwatchClient;
    }

    private void appendUserAgent(PutMetricDataRequest request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
    }
}

