/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.Cluster;
import com.amazonaws.services.ecs.model.Failure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeClustersResult
implements Serializable {
    private ListWithAutoConstructFlag<Cluster> clusters;
    private ListWithAutoConstructFlag<Failure> failures;

    public List<Cluster> getClusters() {
        if (this.clusters == null) {
            this.clusters = new ListWithAutoConstructFlag();
            this.clusters.setAutoConstruct(true);
        }
        return this.clusters;
    }

    public void setClusters(Collection<Cluster> clusters) {
        if (clusters == null) {
            this.clusters = null;
            return;
        }
        ListWithAutoConstructFlag clustersCopy = new ListWithAutoConstructFlag(clusters.size());
        clustersCopy.addAll(clusters);
        this.clusters = clustersCopy;
    }

    public DescribeClustersResult withClusters(Cluster ... clusters) {
        if (this.getClusters() == null) {
            this.setClusters(new ArrayList<Cluster>(clusters.length));
        }
        for (Cluster value : clusters) {
            this.getClusters().add(value);
        }
        return this;
    }

    public DescribeClustersResult withClusters(Collection<Cluster> clusters) {
        if (clusters == null) {
            this.clusters = null;
        } else {
            ListWithAutoConstructFlag clustersCopy = new ListWithAutoConstructFlag(clusters.size());
            clustersCopy.addAll(clusters);
            this.clusters = clustersCopy;
        }
        return this;
    }

    public List<Failure> getFailures() {
        if (this.failures == null) {
            this.failures = new ListWithAutoConstructFlag();
            this.failures.setAutoConstruct(true);
        }
        return this.failures;
    }

    public void setFailures(Collection<Failure> failures) {
        if (failures == null) {
            this.failures = null;
            return;
        }
        ListWithAutoConstructFlag failuresCopy = new ListWithAutoConstructFlag(failures.size());
        failuresCopy.addAll(failures);
        this.failures = failuresCopy;
    }

    public DescribeClustersResult withFailures(Failure ... failures) {
        if (this.getFailures() == null) {
            this.setFailures(new ArrayList<Failure>(failures.length));
        }
        for (Failure value : failures) {
            this.getFailures().add(value);
        }
        return this;
    }

    public DescribeClustersResult withFailures(Collection<Failure> failures) {
        if (failures == null) {
            this.failures = null;
        } else {
            ListWithAutoConstructFlag failuresCopy = new ListWithAutoConstructFlag(failures.size());
            failuresCopy.addAll(failures);
            this.failures = failuresCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusters() != null) {
            sb.append("Clusters: " + this.getClusters() + ",");
        }
        if (this.getFailures() != null) {
            sb.append("Failures: " + this.getFailures());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusters() == null ? 0 : this.getClusters().hashCode());
        hashCode = 31 * hashCode + (this.getFailures() == null ? 0 : this.getFailures().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResult)) {
            return false;
        }
        DescribeClustersResult other = (DescribeClustersResult)obj;
        if (other.getClusters() == null ^ this.getClusters() == null) {
            return false;
        }
        if (other.getClusters() != null && !other.getClusters().equals(this.getClusters())) {
            return false;
        }
        if (other.getFailures() == null ^ this.getFailures() == null) {
            return false;
        }
        return other.getFailures() == null || other.getFailures().equals(this.getFailures());
    }
}

