/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53.model.HostedZone;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListHostedZonesByNameResult
implements Serializable {
    private ListWithAutoConstructFlag<HostedZone> hostedZones;
    private String dNSName;
    private String hostedZoneId;
    private Boolean isTruncated;
    private String nextDNSName;
    private String nextHostedZoneId;
    private String maxItems;

    public List<HostedZone> getHostedZones() {
        if (this.hostedZones == null) {
            this.hostedZones = new ListWithAutoConstructFlag();
            this.hostedZones.setAutoConstruct(true);
        }
        return this.hostedZones;
    }

    public void setHostedZones(Collection<HostedZone> hostedZones) {
        if (hostedZones == null) {
            this.hostedZones = null;
            return;
        }
        ListWithAutoConstructFlag hostedZonesCopy = new ListWithAutoConstructFlag(hostedZones.size());
        hostedZonesCopy.addAll(hostedZones);
        this.hostedZones = hostedZonesCopy;
    }

    public ListHostedZonesByNameResult withHostedZones(HostedZone ... hostedZones) {
        if (this.getHostedZones() == null) {
            this.setHostedZones(new ArrayList<HostedZone>(hostedZones.length));
        }
        for (HostedZone value : hostedZones) {
            this.getHostedZones().add(value);
        }
        return this;
    }

    public ListHostedZonesByNameResult withHostedZones(Collection<HostedZone> hostedZones) {
        if (hostedZones == null) {
            this.hostedZones = null;
        } else {
            ListWithAutoConstructFlag hostedZonesCopy = new ListWithAutoConstructFlag(hostedZones.size());
            hostedZonesCopy.addAll(hostedZones);
            this.hostedZones = hostedZonesCopy;
        }
        return this;
    }

    public String getDNSName() {
        return this.dNSName;
    }

    public void setDNSName(String dNSName) {
        this.dNSName = dNSName;
    }

    public ListHostedZonesByNameResult withDNSName(String dNSName) {
        this.dNSName = dNSName;
        return this;
    }

    public String getHostedZoneId() {
        return this.hostedZoneId;
    }

    public void setHostedZoneId(String hostedZoneId) {
        this.hostedZoneId = hostedZoneId;
    }

    public ListHostedZonesByNameResult withHostedZoneId(String hostedZoneId) {
        this.hostedZoneId = hostedZoneId;
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListHostedZonesByNameResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getNextDNSName() {
        return this.nextDNSName;
    }

    public void setNextDNSName(String nextDNSName) {
        this.nextDNSName = nextDNSName;
    }

    public ListHostedZonesByNameResult withNextDNSName(String nextDNSName) {
        this.nextDNSName = nextDNSName;
        return this;
    }

    public String getNextHostedZoneId() {
        return this.nextHostedZoneId;
    }

    public void setNextHostedZoneId(String nextHostedZoneId) {
        this.nextHostedZoneId = nextHostedZoneId;
    }

    public ListHostedZonesByNameResult withNextHostedZoneId(String nextHostedZoneId) {
        this.nextHostedZoneId = nextHostedZoneId;
        return this;
    }

    public String getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(String maxItems) {
        this.maxItems = maxItems;
    }

    public ListHostedZonesByNameResult withMaxItems(String maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostedZones() != null) {
            sb.append("HostedZones: " + this.getHostedZones() + ",");
        }
        if (this.getDNSName() != null) {
            sb.append("DNSName: " + this.getDNSName() + ",");
        }
        if (this.getHostedZoneId() != null) {
            sb.append("HostedZoneId: " + this.getHostedZoneId() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getNextDNSName() != null) {
            sb.append("NextDNSName: " + this.getNextDNSName() + ",");
        }
        if (this.getNextHostedZoneId() != null) {
            sb.append("NextHostedZoneId: " + this.getNextHostedZoneId() + ",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: " + this.getMaxItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostedZones() == null ? 0 : this.getHostedZones().hashCode());
        hashCode = 31 * hashCode + (this.getDNSName() == null ? 0 : this.getDNSName().hashCode());
        hashCode = 31 * hashCode + (this.getHostedZoneId() == null ? 0 : this.getHostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getNextDNSName() == null ? 0 : this.getNextDNSName().hashCode());
        hashCode = 31 * hashCode + (this.getNextHostedZoneId() == null ? 0 : this.getNextHostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByNameResult)) {
            return false;
        }
        ListHostedZonesByNameResult other = (ListHostedZonesByNameResult)obj;
        if (other.getHostedZones() == null ^ this.getHostedZones() == null) {
            return false;
        }
        if (other.getHostedZones() != null && !other.getHostedZones().equals(this.getHostedZones())) {
            return false;
        }
        if (other.getDNSName() == null ^ this.getDNSName() == null) {
            return false;
        }
        if (other.getDNSName() != null && !other.getDNSName().equals(this.getDNSName())) {
            return false;
        }
        if (other.getHostedZoneId() == null ^ this.getHostedZoneId() == null) {
            return false;
        }
        if (other.getHostedZoneId() != null && !other.getHostedZoneId().equals(this.getHostedZoneId())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getNextDNSName() == null ^ this.getNextDNSName() == null) {
            return false;
        }
        if (other.getNextDNSName() != null && !other.getNextDNSName().equals(this.getNextDNSName())) {
            return false;
        }
        if (other.getNextHostedZoneId() == null ^ this.getNextHostedZoneId() == null) {
            return false;
        }
        if (other.getNextHostedZoneId() != null && !other.getNextHostedZoneId().equals(this.getNextHostedZoneId())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        return other.getMaxItems() == null || other.getMaxItems().equals(this.getMaxItems());
    }
}

