/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CheckDomainAvailabilityRequestMarshaller
implements Marshaller<Request<CheckDomainAvailabilityRequest>, CheckDomainAvailabilityRequest> {
    @Override
    public Request<CheckDomainAvailabilityRequest> marshall(CheckDomainAvailabilityRequest checkDomainAvailabilityRequest) {
        if (checkDomainAvailabilityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CheckDomainAvailabilityRequest> request = new DefaultRequest<CheckDomainAvailabilityRequest>(checkDomainAvailabilityRequest, "AmazonRoute53Domains");
        String target = "Route53Domains_v20140515.CheckDomainAvailability";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (checkDomainAvailabilityRequest.getDomainName() != null) {
                jsonWriter.key("DomainName").value(checkDomainAvailabilityRequest.getDomainName());
            }
            if (checkDomainAvailabilityRequest.getIdnLangCode() != null) {
                jsonWriter.key("IdnLangCode").value(checkDomainAvailabilityRequest.getIdnLangCode());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

