/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDocumentsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private ListWithAutoConstructFlag<DocumentFilter> documentFilterList;
    private Integer maxResults;
    private String nextToken;

    public List<DocumentFilter> getDocumentFilterList() {
        if (this.documentFilterList == null) {
            this.documentFilterList = new ListWithAutoConstructFlag();
            this.documentFilterList.setAutoConstruct(true);
        }
        return this.documentFilterList;
    }

    public void setDocumentFilterList(Collection<DocumentFilter> documentFilterList) {
        if (documentFilterList == null) {
            this.documentFilterList = null;
            return;
        }
        ListWithAutoConstructFlag documentFilterListCopy = new ListWithAutoConstructFlag(documentFilterList.size());
        documentFilterListCopy.addAll(documentFilterList);
        this.documentFilterList = documentFilterListCopy;
    }

    public ListDocumentsRequest withDocumentFilterList(DocumentFilter ... documentFilterList) {
        if (this.getDocumentFilterList() == null) {
            this.setDocumentFilterList(new ArrayList<DocumentFilter>(documentFilterList.length));
        }
        for (DocumentFilter value : documentFilterList) {
            this.getDocumentFilterList().add(value);
        }
        return this;
    }

    public ListDocumentsRequest withDocumentFilterList(Collection<DocumentFilter> documentFilterList) {
        if (documentFilterList == null) {
            this.documentFilterList = null;
        } else {
            ListWithAutoConstructFlag documentFilterListCopy = new ListWithAutoConstructFlag(documentFilterList.size());
            documentFilterListCopy.addAll(documentFilterList);
            this.documentFilterList = documentFilterListCopy;
        }
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public ListDocumentsRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListDocumentsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentFilterList() != null) {
            sb.append("DocumentFilterList: " + this.getDocumentFilterList() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentFilterList() == null ? 0 : this.getDocumentFilterList().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsRequest)) {
            return false;
        }
        ListDocumentsRequest other = (ListDocumentsRequest)obj;
        if (other.getDocumentFilterList() == null ^ this.getDocumentFilterList() == null) {
            return false;
        }
        if (other.getDocumentFilterList() != null && !other.getDocumentFilterList().equals(this.getDocumentFilterList())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

