/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecisionTaskHandler;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskPoller;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorker;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import com.amazonaws.services.simpleworkflow.model.RegisterWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.services.simpleworkflow.model.TypeAlreadyExistsException;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.lang.management.ManagementFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericWorkflowWorker
extends GenericWorker {
    private static final Log log = LogFactory.getLog(GenericWorkflowWorker.class);
    private static final String THREAD_NAME_PREFIX = "SWF Decider ";
    private WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory;

    public GenericWorkflowWorker() {
        this.setIdentity(ManagementFactory.getRuntimeMXBean().getName());
    }

    public GenericWorkflowWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll) {
        this();
        this.setService(service);
        this.setDomain(domain);
        this.setTaskListToPoll(taskListToPoll);
    }

    public WorkflowDefinitionFactoryFactory getWorkflowDefinitionFactoryFactory() {
        return this.workflowDefinitionFactoryFactory;
    }

    public void setWorkflowDefinitionFactoryFactory(WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) {
        this.workflowDefinitionFactoryFactory = workflowDefinitionFactoryFactory;
    }

    protected DecisionTaskPoller createWorkflowPoller() {
        DecisionTaskPoller poller = new DecisionTaskPoller();
        return poller;
    }

    @Override
    protected void checkRequredProperties() {
        this.checkRequiredProperty(this.workflowDefinitionFactoryFactory, "workflowDefinitionFactoryFactory");
    }

    @Override
    protected String getPollThreadNamePrefix() {
        return THREAD_NAME_PREFIX + this.getTaskListToPoll() + " ";
    }

    @Override
    protected TaskPoller createPoller() {
        DecisionTaskPoller result = new DecisionTaskPoller();
        result.setDecisionTaskHandler(new AsyncDecisionTaskHandler(this.workflowDefinitionFactoryFactory));
        result.setDomain(this.getDomain());
        result.setIdentity(this.getIdentity());
        result.setService(this.getService());
        result.setTaskListToPoll(this.getTaskListToPoll());
        return result;
    }

    @Override
    public void registerTypesToPoll() {
        GenericWorkflowWorker.registerWorkflowTypes(this.service, this.domain, this.getTaskListToPoll(), this.workflowDefinitionFactoryFactory);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[super=" + super.toString() + ", workflowDefinitionFactoryFactory=" + this.workflowDefinitionFactoryFactory + "]";
    }

    public static void registerWorkflowTypes(AmazonSimpleWorkflow service, String domain, String defaultTaskList, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) {
        for (WorkflowType typeToRegister : workflowDefinitionFactoryFactory.getWorkflowTypesToRegister()) {
            WorkflowDefinitionFactory workflowDefinitionFactory = workflowDefinitionFactoryFactory.getWorkflowDefinitionFactory(typeToRegister);
            WorkflowTypeRegistrationOptions registrationOptions = workflowDefinitionFactory.getWorkflowRegistrationOptions();
            if (registrationOptions == null) continue;
            WorkflowType workflowType = workflowDefinitionFactory.getWorkflowType();
            try {
                GenericWorkflowWorker.registerWorkflowType(service, domain, workflowType, registrationOptions, defaultTaskList);
            }
            catch (TypeAlreadyExistsException typeAlreadyExistsException) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Workflow Type already registered: " + workflowType);
            }
        }
    }

    public static void registerWorkflowType(AmazonSimpleWorkflow service, String domain, WorkflowType workflowType, WorkflowTypeRegistrationOptions registrationOptions, String defaultTaskList) {
        RegisterWorkflowTypeRequest registerWorkflow = new RegisterWorkflowTypeRequest();
        registerWorkflow.setDomain(domain);
        registerWorkflow.setName(workflowType.getName());
        registerWorkflow.setVersion(workflowType.getVersion());
        String taskList = registrationOptions.getDefaultTaskList();
        if (taskList == null) {
            taskList = defaultTaskList;
        } else if (taskList.equals("NO_DEFAULT_TASK_LIST")) {
            taskList = null;
        }
        if (taskList != null && !taskList.isEmpty()) {
            registerWorkflow.setDefaultTaskList(new TaskList().withName(taskList));
        }
        registerWorkflow.setDefaultChildPolicy(registrationOptions.getDefaultChildPolicy().toString());
        registerWorkflow.setDefaultTaskStartToCloseTimeout(FlowHelpers.secondsToDuration(registrationOptions.getDefaultTaskStartToCloseTimeoutSeconds()));
        registerWorkflow.setDefaultExecutionStartToCloseTimeout(FlowHelpers.secondsToDuration(registrationOptions.getDefaultExecutionStartToCloseTimeoutSeconds()));
        registerWorkflow.setDefaultTaskPriority(FlowHelpers.taskPriorityToString(registrationOptions.getDefaultTaskPriority()));
        String description = registrationOptions.getDescription();
        if (description != null) {
            registerWorkflow.setDescription(description);
        }
        service.registerWorkflowType(registerWorkflow);
    }
}

