/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.BaseEntity;
import org.duracloud.account.db.model.Role;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
public class DuracloudUser
extends BaseEntity
implements UserDetails {
    private String username;
    private String password;
    private String firstName;
    private String lastName;
    private String email;
    private String securityQuestion;
    private String securityAnswer;
    private boolean enabled = true;
    private boolean accountNonExpired = true;
    private boolean credentialsNonExpired = true;
    private boolean accountNonLocked = true;
    private String allowableIPAddressRange;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="user")
    private Set<AccountRights> accountRights;
    private boolean root = false;

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public String getSecurityAnswer() {
        return this.securityAnswer;
    }

    public void setSecurityAnswer(String securityAnswer) {
        this.securityAnswer = securityAnswer;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        this.accountNonExpired = accountNonExpired;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        this.credentialsNonExpired = credentialsNonExpired;
    }

    @Override
    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
    }

    public Set<AccountRights> getAccountRights() {
        return this.accountRights;
    }

    public void setAccountRights(Set<AccountRights> accountRights) {
        this.accountRights = accountRights;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        for (Role role : Role.ROLE_USER.getRoleHierarchy()) {
            authorities.add(new GrantedAuthorityImpl(role.name()));
        }
        if (this.accountRights != null) {
            for (AccountRights rights : this.accountRights) {
                Set<Role> roles = rights.getRoles();
                if (roles == null) continue;
                for (Role role : roles) {
                    authorities.add(role.authority());
                }
            }
        }
        if (this.isRoot()) {
            authorities.add(new GrantedAuthorityImpl(Role.ROLE_ROOT.name()));
        }
        return authorities;
    }

    public Set<Role> getRolesByAcct(Long accountId) {
        Set<Role> roles = new HashSet<Role>(0);
        if (this.accountRights != null) {
            for (AccountRights rights : this.getAccountRights()) {
                if (!rights.getAccount().getId().equals(accountId)) continue;
                roles = rights.getRoles();
            }
        }
        return roles;
    }

    public Role getRoleByAcct(Long accountId) {
        if (this.isRoot()) {
            return Role.ROLE_ROOT;
        }
        Set<Role> roles = this.getRolesByAcct(accountId);
        return Role.highestRole(roles);
    }

    public boolean isOwnerForAcct(Long accountId) {
        return this.hasRoleForAcct(accountId, Role.ROLE_OWNER);
    }

    public boolean isAdminForAcct(Long accountId) {
        return this.hasRoleForAcct(accountId, Role.ROLE_ADMIN);
    }

    public boolean hasRoleForAcct(Long accountId, Role role) {
        Set<Role> roles = this.getRolesByAcct(accountId);
        if (roles != null) {
            return roles.contains((Object)role);
        }
        return false;
    }

    public boolean isRootUser() {
        return this.root;
    }

    public boolean isRoot() {
        return this.root;
    }

    public String getAllowableIPAddressRange() {
        return this.allowableIPAddressRange;
    }

    public void setAllowableIPAddressRange(String allowableIPAddressRange) {
        this.allowableIPAddressRange = allowableIPAddressRange;
    }
}

