/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util;

import java.util.Set;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.ComputeProviderAccount;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.ServerDetails;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.model.UserInvitation;
import org.duracloud.notification.Emailer;
import org.duracloud.storage.domain.StorageProviderType;
import org.springframework.security.access.annotation.Secured;

public interface AccountService {
    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public Long getAccountId();

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT"})
    public AccountInfo retrieveAccountInfo();

    @Secured(value={"role:ROLE_OWNER, scope:SELF_ACCT"})
    public void storeAccountInfo(String var1, String var2, String var3);

    @Secured(value={"role:ROLE_OWNER, scope:SELF_ACCT"})
    public void storeAccountStatus(AccountInfo.AccountStatus var1);

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT"})
    public ServerDetails retrieveServerDetails();

    @Secured(value={"role:ROLE_OWNER, scope:SELF_ACCT"})
    public void storeServerDetails(ServerDetails var1);

    @Secured(value={"role:ROLE_OWNER, scope:SELF_ACCT"})
    public void storeSubdomain(String var1);

    @Secured(value={"role:ROLE_USER, scope:SELF_ACCT"})
    public String getSubdomain();

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT"})
    public StorageProviderAccount getPrimaryStorageProvider();

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT"})
    public ComputeProviderAccount getComputeProvider();

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT"})
    public Set<StorageProviderAccount> getSecondaryStorageProviders();

    @Secured(value={"role:ROLE_OWNER, scope:SELF_ACCT"})
    public void addStorageProvider(StorageProviderType var1);

    @Secured(value={"role:ROLE_OWNER, scope:SELF_ACCT"})
    public void setPrimaryStorageProviderRrs(boolean var1);

    @Secured(value={"role:ROLE_OWNER, scope:SELF_ACCT"})
    public void removeStorageProvider(Long var1);

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public Set<DuracloudUser> getUsers();

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT"})
    public UserInvitation inviteUser(String var1, String var2, Emailer var3);

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT"})
    public Set<UserInvitation> getPendingInvitations();

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT"})
    public void deleteUserInvitation(Long var1);
}

