/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util;

import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.Role;
import org.duracloud.account.db.model.UserInvitation;
import org.duracloud.account.db.util.error.DBNotFoundException;
import org.duracloud.account.db.util.error.InvalidPasswordException;
import org.duracloud.account.db.util.error.InvalidRedemptionCodeException;
import org.duracloud.account.db.util.error.InvalidUsernameException;
import org.duracloud.account.db.util.error.UnsentEmailException;
import org.duracloud.account.db.util.error.UserAlreadyExistsException;
import org.springframework.security.access.annotation.Secured;

public interface DuracloudUserService {
    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public void checkUsername(String var1) throws InvalidUsernameException, UserAlreadyExistsException;

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public DuracloudUser createNewUser(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws UserAlreadyExistsException, InvalidUsernameException;

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT_PEER_UPDATE"})
    public boolean setUserRights(Long var1, Long var2, Role ... var3);

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT"})
    public boolean addUserToAccount(Long var1, Long var2) throws DBNotFoundException;

    @Secured(value={"role:ROLE_ADMIN, scope:SELF_ACCT_PEER"})
    public void revokeUserRights(Long var1, Long var2);

    @Secured(value={"role:ROLE_USER, scope:SELF_ID"})
    public void changePassword(Long var1, String var2, boolean var3, String var4) throws DBNotFoundException, InvalidPasswordException;

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public void changePasswordInternal(Long var1, String var2, boolean var3, String var4) throws DBNotFoundException, InvalidPasswordException;

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public void forgotPassword(String var1, String var2, String var3) throws DBNotFoundException, InvalidPasswordException, UnsentEmailException;

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public UserInvitation retrievePassordChangeInvitation(String var1) throws DBNotFoundException;

    @Secured(value={"role:ROLE_USER, scope:SELF_NAME"})
    public DuracloudUser loadDuracloudUserByUsername(String var1) throws DBNotFoundException;

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public DuracloudUser loadDuracloudUserByUsernameInternal(String var1) throws DBNotFoundException;

    @Secured(value={"role:ROLE_USER, scope:ANY"})
    public DuracloudUser loadDuracloudUserByIdInternal(Long var1) throws DBNotFoundException;

    @Secured(value={"role:ROLE_USER, scope:SELF_ID"})
    public Long redeemAccountInvitation(Long var1, String var2) throws InvalidRedemptionCodeException;

    @Secured(value={"role:ROLE_ANONYMOUS, scope:ANY"})
    public void redeemPasswordChangeRequest(Long var1, String var2) throws InvalidRedemptionCodeException;

    @Secured(value={"role:ROLE_USER, scope:SELF_ID"})
    public void storeUserDetails(Long var1, String var2, String var3, String var4, String var5, String var6, String var7) throws DBNotFoundException;
}

