/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import org.duracloud.account.compute.ComputeProviderUtil;
import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.DuracloudInstanceService;
import org.duracloud.account.db.util.DuracloudInstanceServiceFactory;
import org.duracloud.account.db.util.DuracloudMillConfigService;
import org.duracloud.account.db.util.impl.DuracloudInstanceServiceImpl;
import org.duracloud.account.db.util.impl.DuracloudInstanceServiceSecuredImpl;
import org.duracloud.account.db.util.notification.NotificationMgr;
import org.duracloud.account.db.util.security.AnnotationParser;
import org.duracloud.account.db.util.security.SecurityContextUtil;
import org.duracloud.account.db.util.util.UserFinderUtil;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.error.NoUserLoggedInException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.core.Authentication;

public class DuracloudInstanceServiceFactoryImpl
implements DuracloudInstanceServiceFactory {
    private Logger log = LoggerFactory.getLogger(DuracloudInstanceServiceFactoryImpl.class);
    private DuracloudRepoMgr repoMgr;
    private AccessDecisionVoter voter;
    private SecurityContextUtil securityContext;
    private UserFinderUtil userFinderUtil;
    private ComputeProviderUtil computeUtil;
    private AnnotationParser annotationParser;
    private NotificationMgr notificationMgr;
    private AmaEndpoint amaEndpoint;
    private DuracloudMillConfigService duracloudMillService;

    public DuracloudInstanceServiceFactoryImpl(DuracloudRepoMgr repoMgr, AccessDecisionVoter voter, SecurityContextUtil securityContext, UserFinderUtil userFinderUtil, ComputeProviderUtil computeUtil, AnnotationParser annotationParser, NotificationMgr notificationMgr, AmaEndpoint amaEndpoint, DuracloudMillConfigService duracloudMillService) {
        this.repoMgr = repoMgr;
        this.voter = voter;
        this.securityContext = securityContext;
        this.userFinderUtil = userFinderUtil;
        this.computeUtil = computeUtil;
        this.annotationParser = annotationParser;
        this.notificationMgr = notificationMgr;
        this.amaEndpoint = amaEndpoint;
        this.duracloudMillService = duracloudMillService;
    }

    @Override
    public DuracloudInstanceService getInstance(DuracloudInstance instance) {
        DuracloudInstanceServiceImpl instanceService = new DuracloudInstanceServiceImpl(instance.getAccount().getId(), instance, this.repoMgr, this.userFinderUtil, this.computeUtil, this.notificationMgr.getConfig(), this.amaEndpoint, this.duracloudMillService);
        Authentication authentication = this.getAuthentication();
        return new DuracloudInstanceServiceSecuredImpl(instanceService, authentication, this.voter, this.annotationParser);
    }

    private Authentication getAuthentication() {
        try {
            return this.securityContext.getAuthentication();
        }
        catch (NoUserLoggedInException e) {
            this.log.warn("No user found in security context.");
            throw new DuraCloudRuntimeException(e);
        }
    }
}

