/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.UserInvitation;

public class InvitationMessageFormatter {
    private UserInvitation invitation;
    private AmaEndpoint endpoint;

    public InvitationMessageFormatter(UserInvitation invitation, AmaEndpoint amaEndpoint) {
        this.invitation = invitation;
        this.endpoint = amaEndpoint;
    }

    public String getSubject() {
        return "DuraCloud Account Invitation";
    }

    public String getBody() {
        StringBuilder sb = new StringBuilder();
        sb.append("You have been invited to join the DuraCloud account which is managed by ");
        sb.append(this.invitation.getAccountOrg());
        if (this.invitation.getAccountDep() != null && !this.invitation.getAccountDep().equals("")) {
            sb.append(", ");
            sb.append(this.invitation.getAccountDep());
        }
        sb.append(". After accepting this invitation, you will be given access to the ");
        sb.append(this.invitation.getAccountName());
        sb.append(" account and will be able to log in to https://");
        sb.append(this.invitation.getAccountSubdomain());
        sb.append(".duracloud.org. In order to join, please follow these instructions:");
        sb.append("\n\n");
        sb.append("1. If you do not have a personal user profile with ");
        sb.append("DuraCloud, please create one at: ");
        sb.append(this.getNewProfileURL());
        sb.append(" ");
        sb.append("If you already have a personal user profile with ");
        sb.append("DuraCloud, you may skip this step.");
        sb.append("\n");
        sb.append("2. Click on this link to log in to the DuraCloud ");
        sb.append("Management Console: ");
        sb.append(this.getRedemptionURL());
        sb.append("\n");
        sb.append("3. After logging in, you should see the details for the ");
        sb.append("DuraCloud account that you now have access to.");
        sb.append("\n\n");
        sb.append("If you have any issues accepting the invitation or ");
        sb.append("creating your personal user profile, please contact the ");
        sb.append("DuraCloud team by emailing your issue to ");
        sb.append("support@duracloud.org.");
        sb.append("\n");
        sb.append("\n");
        sb.append("The DuraCloud team");
        return sb.toString();
    }

    public String getRedemptionURL() {
        return this.endpoint.getUrl() + "/users/redeem/" + this.invitation.getRedemptionCode();
    }

    private String getNewProfileURL() {
        return this.endpoint.getUrl() + "/users/new";
    }
}

