/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.security;

import org.duracloud.common.error.NoUserLoggedInException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityContextUtil {
    private final Logger log = LoggerFactory.getLogger(SecurityContextUtil.class);

    public Authentication getAuthentication() throws NoUserLoggedInException {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication auth = context.getAuthentication();
        if (null == auth) {
            this.log.debug("no user-auth found.");
            throw new NoUserLoggedInException();
        }
        return auth;
    }

    static {
        SecurityContextHolder.setStrategyName("MODE_INHERITABLETHREADLOCAL");
    }
}

