/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.sys.impl;

import org.duracloud.account.db.model.util.AccountCreationInfo;
import org.duracloud.account.db.util.notification.NotificationMgr;
import org.duracloud.account.db.util.sys.EventMonitor;
import org.duracloud.account.db.util.sys.impl.SystemMonitorImpl;
import org.duracloud.notification.Emailer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventMonitorBase
implements EventMonitor {
    private Logger log = LoggerFactory.getLogger(SystemMonitorImpl.class);
    private NotificationMgr notificationMgr;

    public EventMonitorBase(NotificationMgr notificationMgr) {
        this.notificationMgr = notificationMgr;
    }

    @Override
    public void accountCreated(AccountCreationInfo acctInfo) {
        this.log.debug("Acct created for acct:{}", (Object)acctInfo.getSubdomain());
        Emailer emailer = this.notificationMgr.getEmailer();
        String subj = this.buildSubj(acctInfo);
        String body = this.buildBody(acctInfo);
        String[] recipients = this.buildRecipients();
        emailer.send(subj, body, recipients);
    }

    protected abstract String buildSubj(AccountCreationInfo var1);

    protected abstract String buildBody(AccountCreationInfo var1);

    protected abstract String[] buildRecipients();
}

