/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.sys.impl;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.config.McConfig;
import org.duracloud.account.db.model.util.AccountCreationInfo;
import org.duracloud.account.db.util.notification.NotificationMgr;
import org.duracloud.account.db.util.sys.impl.EventMonitorBase;
import org.duracloud.storage.domain.StorageProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMonitorImpl
extends EventMonitorBase {
    private Logger log = LoggerFactory.getLogger(SystemMonitorImpl.class);
    private Set<String> recipients = new HashSet<String>();
    private AmaEndpoint amaEndpoint;

    public SystemMonitorImpl(NotificationMgr notificationMgr, McConfig config, AmaEndpoint amaEndpoint) {
        super(notificationMgr);
        String adminEmail = config.getNotificationAdminAddress();
        if (null != adminEmail) {
            this.recipients.clear();
            this.recipients.add(adminEmail);
        }
        this.amaEndpoint = amaEndpoint;
    }

    @Override
    protected String buildSubj(AccountCreationInfo acctInfo) {
        return "Successful creation of DuraCloud account: " + acctInfo.getSubdomain();
    }

    @Override
    protected String buildBody(AccountCreationInfo acctInfo) {
        this.log.debug("Building email for acct:{}", (Object)acctInfo.getSubdomain());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printer = new PrintStream(out);
        printer.printf("Welcome to your new DuraCloud account. ", new Object[0]);
        printer.printf("You have registered under the subdomain:%n", new Object[0]);
        printer.printf("    %1$s%n%n", acctInfo.getSubdomain());
        Set<StorageProviderType> providers = acctInfo.getSecondaryStorageProviderTypes();
        if (null != providers && providers.size() > 0) {
            printer.printf("with the following storage providers: %n", new Object[0]);
            printer.printf("    %1s%n", new Object[]{acctInfo.getPrimaryStorageProviderType()});
            for (StorageProviderType provider : acctInfo.getSecondaryStorageProviderTypes()) {
                printer.printf("    %1s%n", new Object[]{provider});
            }
        }
        printer.print("Feel free to invite additional users to the account, ");
        printer.print("monitor your service status, and update your account ");
        printer.printf("preferences at: %n", new Object[0]);
        printer.printf("    %1$s%n%n", this.amaEndpoint.getUrl());
        printer.printf("%nThank you,%nDuraCloud Team%n", new Object[0]);
        printer.close();
        return out.toString();
    }

    @Override
    protected String[] buildRecipients() {
        return this.recipients.toArray(new String[0]);
    }
}

