/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.usermgmt.impl;

import java.util.HashSet;
import java.util.Set;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.Role;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.DuracloudInstanceManagerService;
import org.duracloud.account.db.util.DuracloudInstanceService;
import org.duracloud.account.db.util.usermgmt.UserDetailsPropagator;
import org.duracloud.account.db.util.util.UserFinderUtil;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDetailsPropagatorImpl
implements UserDetailsPropagator {
    private Logger log = LoggerFactory.getLogger(UserDetailsPropagatorImpl.class);
    private DuracloudRepoMgr repoMgr;
    private DuracloudInstanceManagerService instanceManagerService;
    private Exception error = null;
    private UserFinderUtil userFinder;

    public UserDetailsPropagatorImpl(DuracloudRepoMgr repoMgr, DuracloudInstanceManagerService instanceManagerService, UserFinderUtil userFinder) {
        this.repoMgr = repoMgr;
        this.instanceManagerService = instanceManagerService;
        this.userFinder = userFinder;
    }

    @Override
    public void propagateRevocation(Long acctId, Long userId) {
        this.propagateRights(acctId, userId, null);
    }

    @Override
    public void propagateRights(Long acctId, Long userId, Set<Role> roles) {
        Set<DuracloudUser> users = this.findUsers(acctId);
        if (null == roles) {
            users = this.removeUser(userId, users);
        }
        this.doPropagate(acctId, users);
        this.checkForErrors(acctId, userId, "userId");
    }

    @Override
    public void propagateUserUpdate(Long acctId, Long userId) {
        Set<DuracloudUser> users = this.findUsers(acctId);
        this.doPropagate(acctId, users);
        this.checkForErrors(acctId, userId, "userId");
    }

    @Override
    public void propagateGroupUpdate(Long acctId, Long groupId) {
        Set<DuracloudUser> users = this.findUsers(acctId);
        this.doPropagate(acctId, users);
        this.checkForErrors(acctId, groupId, "groupId");
    }

    private void checkForErrors(Long acctId, Long id, String idName) {
        if (null != this.error) {
            StringBuilder msg = new StringBuilder("Failed to propagate, ");
            msg.append("acctId: ");
            msg.append(acctId);
            msg.append(", ");
            msg.append(idName);
            msg.append(": ");
            msg.append(id);
            throw new DuraCloudRuntimeException(msg.toString(), this.error);
        }
    }

    private Set<DuracloudUser> findUsers(Long acctId) {
        HashSet<DuracloudUser> users = new HashSet();
        AccountInfo acctInfo = (AccountInfo)this.repoMgr.getAccountRepo().findOne(acctId);
        users = this.userFinder.getAccountUsers(acctInfo);
        return users;
    }

    private Set<DuracloudUser> removeUser(Long userId, Set<DuracloudUser> users) {
        HashSet<DuracloudUser> results = new HashSet<DuracloudUser>();
        for (DuracloudUser user : users) {
            if (userId.longValue() == user.getId().longValue()) continue;
            results.add(user);
        }
        return results;
    }

    private void doPropagate(Long acctId, Set<DuracloudUser> users) {
        this.log.debug("propagating user roles for acct: " + acctId);
        Set<DuracloudInstanceService> services = this.instanceManagerService.getInstanceServices(acctId);
        for (DuracloudInstanceService service : services) {
            DuracloudInstance instanceInfo = service.getInstanceInfo();
            this.log.debug("propagating user roles: {}, {}", (Object)instanceInfo.getHostName(), (Object)users);
            service.setUserRoles(users);
        }
    }
}

