/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.common;

import java.util.List;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.model.ServerImage;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.repo.DuracloudInstanceRepo;
import org.duracloud.account.db.repo.DuracloudServerImageRepo;
import org.duracloud.account.db.util.error.DBNotFoundException;
import org.duracloud.common.model.Credential;
import org.slf4j.Logger;

public abstract class BaseMonitor {
    private static final String HOST_SUFFIX = ".duracloud.org";
    protected Logger log;
    protected DuracloudAccountRepo acctRepo;
    protected DuracloudInstanceRepo instanceRepo;
    protected DuracloudServerImageRepo imageRepo;

    protected void init(DuracloudAccountRepo acctRepo, DuracloudInstanceRepo instanceRepo, DuracloudServerImageRepo imageRepo) {
        this.acctRepo = acctRepo;
        this.instanceRepo = instanceRepo;
        this.imageRepo = imageRepo;
    }

    protected AccountInfo getAccount(String host) throws DBNotFoundException {
        String subdomain = host;
        if (subdomain.endsWith(HOST_SUFFIX)) {
            subdomain = host.substring(0, host.indexOf(HOST_SUFFIX));
        }
        return this.acctRepo.findBySubdomain(subdomain);
    }

    protected ServerImage findServerImage(AccountInfo acct) throws DBNotFoundException {
        List<DuracloudInstance> instances = this.instanceRepo.findByAccountId(acct.getId());
        return instances.iterator().next().getImage();
    }

    protected List<DuracloudInstance> getDuracloudInstances() {
        return this.instanceRepo.findAll();
    }

    protected Credential getRootCredential(DuracloudInstance instance) {
        String rootPassword = instance.getImage().getDcRootPassword();
        return new Credential("root", rootPassword);
    }
}

