/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.duplication.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.duracloud.common.error.DuraCloudRuntimeException;

public class DuplicationPropReader {
    private static final String PREFIX = "duplication.";
    private static final String HOST = ".host";
    private static final String SPACES = ".spaces";
    protected static final String ALL_SPACES = "ALL";

    public Map<String, String> readDupProps(Properties props) {
        HashMap<String, String> dupHosts = new HashMap<String, String>();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith(PREFIX)) continue;
            String propValue = this.getProperty(props, propName);
            if (propName.endsWith(HOST)) {
                String spacesProp = propName.replace(HOST, SPACES);
                String spacesVal = this.getProperty(props, spacesProp);
                dupHosts.put(propValue, spacesVal);
                continue;
            }
            if (propName.endsWith(SPACES)) continue;
            dupHosts.put(propValue, ALL_SPACES);
        }
        return dupHosts;
    }

    private String getProperty(Properties props, String key) {
        String property = props.getProperty(key);
        if (null == property) {
            throw new DuraCloudRuntimeException("Property not found: " + key);
        }
        return property;
    }
}

