/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.instance;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.repo.DuracloudInstanceRepo;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.monitor.MonitorsDriver;
import org.duracloud.account.monitor.instance.InstanceMonitor;
import org.duracloud.account.monitor.instance.domain.InstanceReport;
import org.duracloud.account.monitor.instance.util.impl.InstanceUtilFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceMonitorDriver
extends MonitorsDriver
implements Runnable {
    private Logger log = LoggerFactory.getLogger(InstanceMonitorDriver.class);
    private InstanceMonitor instanceMonitor;

    public InstanceMonitorDriver(Properties props) {
        super(props);
        DuracloudRepoMgr repoMgr = this.getRepoMgr();
        DuracloudAccountRepo acctRepo = repoMgr.getAccountRepo();
        DuracloudInstanceRepo instanceRepo = repoMgr.getInstanceRepo();
        InstanceUtilFactoryImpl instanceUtilFactory = new InstanceUtilFactoryImpl();
        this.instanceMonitor = new InstanceMonitor(acctRepo, instanceRepo, instanceUtilFactory);
    }

    @Override
    public void run() {
        this.log.info("starting monitor");
        try {
            InstanceReport report = this.instanceMonitor.monitorInstances();
            if (report.hasErrors()) {
                StringBuilder subject = new StringBuilder();
                subject.append("Management Console Instance Monitor");
                subject.append(", with Errors!");
                this.sendEmail(subject.toString(), report.toString());
            }
        }
        catch (Exception e) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream error = new PrintStream(out);
            error.println("Error in InstanceMonitor: " + e.getMessage());
            e.printStackTrace(error);
            error.flush();
            IOUtils.closeQuietly(out);
            String msg = new String(out.toByteArray());
            this.log.error(msg);
            this.sendEmail("Management Console Instance Monitor Error", msg);
        }
    }
}

