/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.storereporter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.repo.DuracloudInstanceRepo;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.repo.DuracloudServerImageRepo;
import org.duracloud.account.monitor.MonitorsDriver;
import org.duracloud.account.monitor.storereporter.StoreReporterMonitor;
import org.duracloud.account.monitor.storereporter.domain.StoreReporterReport;
import org.duracloud.account.monitor.storereporter.util.impl.StoreReporterUtilFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreReporterMonitorDriver
extends MonitorsDriver
implements Runnable {
    private Logger log = LoggerFactory.getLogger(StoreReporterMonitorDriver.class);
    private static final String PREFIX = "storereporter.";
    private static final String THRESHOLD_DAYS = "storereporter.threshold";
    private StoreReporterMonitor reporterMonitor;

    public StoreReporterMonitorDriver(Properties props) {
        super(props);
        DuracloudRepoMgr repoMgr = this.getRepoMgr();
        DuracloudAccountRepo acctRepo = repoMgr.getAccountRepo();
        DuracloudInstanceRepo instanceRepo = repoMgr.getInstanceRepo();
        DuracloudServerImageRepo imageRepo = repoMgr.getServerImageRepo();
        int thresholdDays = this.getThresholdDays(props);
        StoreReporterUtilFactoryImpl storeReporterUtilFactory = new StoreReporterUtilFactoryImpl(thresholdDays);
        this.reporterMonitor = new StoreReporterMonitor(acctRepo, instanceRepo, imageRepo, storeReporterUtilFactory);
    }

    private int getThresholdDays(Properties props) {
        return Integer.parseInt(this.getProperty(props, THRESHOLD_DAYS));
    }

    @Override
    public void run() {
        this.log.info("starting monitor");
        try {
            StoreReporterReport report = this.reporterMonitor.monitorStoreReporters();
            if (report.hasErrors()) {
                StringBuilder subject = new StringBuilder();
                subject.append("Management Console Storage-Reporter Monitor");
                subject.append(", with Errors!");
                this.sendEmail(subject.toString(), report.toString());
            }
        }
        catch (Exception e) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream error = new PrintStream(out);
            error.println("Error in StoreReporterMonitor: " + e.getMessage());
            e.printStackTrace(error);
            error.flush();
            IOUtils.closeQuietly(out);
            String msg = new String(out.toByteArray());
            this.log.error(msg);
            this.sendEmail("Management Console Storage-Reporter Monitor Error", msg);
        }
    }
}

