/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.monitor.storereporter.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.monitor.storereporter.domain.StoreReporterInfo;

public class StoreReporterReport {
    private Map<AccountInfo, StoreReporterInfo> reporterInfos = new HashMap<AccountInfo, StoreReporterInfo>();

    public void addAcctError(AccountInfo acct, String error) {
        StoreReporterInfo instance = new StoreReporterInfo(acct.getSubdomain());
        instance.setError(error);
        this.reporterInfos.put(acct, instance);
    }

    public void addAcctInfo(AccountInfo acct, StoreReporterInfo reporterInfo) {
        this.reporterInfos.put(acct, reporterInfo);
    }

    public Map<AccountInfo, StoreReporterInfo> getReporterInfos() {
        return this.reporterInfos;
    }

    public Map<AccountInfo, StoreReporterInfo> getReporterErrors() {
        HashMap<AccountInfo, StoreReporterInfo> reporterErrors = new HashMap<AccountInfo, StoreReporterInfo>();
        for (AccountInfo acct : this.reporterInfos.keySet()) {
            StoreReporterInfo instance = this.reporterInfos.get(acct);
            if (!instance.hasErrors()) continue;
            reporterErrors.put(acct, instance);
        }
        return reporterErrors;
    }

    public boolean hasErrors() {
        for (StoreReporterInfo instance : this.reporterInfos.values()) {
            if (!instance.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("---------------------\n");
        sb.append("Accounts with errors:\n");
        sb.append("---------------------\n");
        ArrayList<AccountInfo> accts = new ArrayList<AccountInfo>();
        for (AccountInfo acct : this.reporterInfos.keySet()) {
            accts.add(acct);
        }
        Collections.sort(accts);
        for (AccountInfo acctInfo : accts) {
            StoreReporterInfo instanceInfo = this.reporterInfos.get(acctInfo);
            if (null == instanceInfo || !instanceInfo.hasErrors()) continue;
            sb.append("Account: (");
            sb.append(acctInfo.getAcctName());
            sb.append(") ");
            sb.append(instanceInfo);
            sb.append("\n\n");
        }
        return sb.toString();
    }
}

