/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.appconfig.domain;

import org.duracloud.appconfig.domain.AppConfig;
import org.duracloud.appconfig.domain.BaseConfig;
import org.duracloud.appconfig.xml.DuradminInitDocumentBinding;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuradminConfig
extends BaseConfig
implements AppConfig {
    private final Logger log = LoggerFactory.getLogger(DuradminConfig.class);
    public static final String QUALIFIER = "duradmin";
    public static final String duraStoreHostKey = "durastore-host";
    public static final String duraStorePortKey = "durastore-port";
    public static final String duraStoreContextKey = "durastore-context";
    public static final String duraBossContextKey = "duraboss-context";
    public static final String millDbEnabledKey = "milldb.enabled";
    public static final String amaUrlKey = "ama-url";
    private String durastoreHost;
    private String durastorePort;
    private String durastoreContext;
    private String durabossContext;
    private boolean millDbEnabled = false;
    private String amaUrl;

    @Override
    public String asXml() {
        return DuradminInitDocumentBinding.createDocumentFrom(this);
    }

    @Override
    public String getInitResource() {
        return "/init";
    }

    @Override
    protected String getQualifier() {
        return QUALIFIER;
    }

    @Override
    protected void loadProperty(String key, String value) {
        if ((key = key.toLowerCase()).equalsIgnoreCase(duraStoreHostKey)) {
            this.durastoreHost = value;
        } else if (key.equalsIgnoreCase(duraStorePortKey)) {
            this.durastorePort = value;
        } else if (key.equalsIgnoreCase(duraStoreContextKey)) {
            this.durastoreContext = value;
        } else if (key.equalsIgnoreCase(duraBossContextKey)) {
            this.durabossContext = value;
            this.durabossContext = value;
        } else if (key.equalsIgnoreCase(amaUrlKey)) {
            this.amaUrl = value;
        } else if (key.equalsIgnoreCase(millDbEnabledKey)) {
            this.millDbEnabled = Boolean.valueOf(value);
        } else if (!this.subclassLoadProperty(key, value)) {
            String msg = "unknown key: " + key + " (" + value + ")";
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
    }

    protected boolean subclassLoadProperty(String key, String value) {
        return false;
    }

    public String getDurastoreHost() {
        return this.durastoreHost;
    }

    public void setDurastoreHost(String durastoreHost) {
        this.durastoreHost = durastoreHost;
    }

    public String getDurastorePort() {
        return this.durastorePort;
    }

    public void setDurastorePort(String durastorePort) {
        this.durastorePort = durastorePort;
    }

    public String getDurastoreContext() {
        return this.durastoreContext;
    }

    public void setDurastoreContext(String durastoreContext) {
        this.durastoreContext = durastoreContext;
    }

    public String getAmaUrl() {
        return this.amaUrl;
    }

    public void setAmaUrl(String amaUrl) {
        this.amaUrl = amaUrl;
    }

    public String getDurabossContext() {
        return this.durabossContext;
    }

    public void setDurabossContext(String durabossContext) {
        this.durabossContext = durabossContext;
    }

    public Boolean isMillDbEnabled() {
        return this.millDbEnabled;
    }

    public void setMillDbEnabled(boolean millDbEnabled) {
        this.millDbEnabled = millDbEnabled;
    }
}

