/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.SessionFactoryAwareNode;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.LiteralType;
import org.hibernate.type.Type;

public class JavaConstantNode
extends Node
implements ExpectedTypeAwareNode,
SessionFactoryAwareNode {
    private SessionFactoryImplementor factory;
    private String constantExpression;
    private Object constantValue;
    private Type heuristicType;
    private Type expectedType;

    @Override
    public void setText(String s) {
        if (StringHelper.isNotEmpty(s)) {
            this.constantExpression = s;
            this.constantValue = ReflectHelper.getConstantValue(s);
            this.heuristicType = this.factory.getTypeResolver().heuristicType(this.constantValue.getClass().getName());
            super.setText(s);
        }
    }

    @Override
    public void setExpectedType(Type expectedType) {
        this.expectedType = expectedType;
    }

    @Override
    public Type getExpectedType() {
        return this.expectedType;
    }

    @Override
    public void setSessionFactory(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    @Override
    public String getRenderText(SessionFactoryImplementor sessionFactory) {
        Type type = this.expectedType == null ? this.heuristicType : (Number.class.isAssignableFrom(this.heuristicType.getReturnedClass()) ? this.heuristicType : this.expectedType);
        try {
            LiteralType literalType = (LiteralType)((Object)type);
            Dialect dialect = this.factory.getDialect();
            return literalType.objectToSQLString(this.constantValue, dialect);
        }
        catch (Exception t) {
            throw new QueryException("Could not format constant value to SQL literal: " + this.constantExpression, t);
        }
    }
}

