/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.geo;

import java.io.Serializable;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.util.Assert;

public class Distance
implements Serializable {
    private static final long serialVersionUID = 2460886201934027744L;
    private final double value;
    private final Metric metric;

    public Distance(double value) {
        this(value, Metrics.NEUTRAL);
    }

    public Distance(double value, Metric metric) {
        this.value = value;
        this.metric = metric == null ? Metrics.NEUTRAL : metric;
    }

    public double getValue() {
        return this.value;
    }

    public double getNormalizedValue() {
        return this.value / this.metric.getMultiplier();
    }

    public Metric getMetric() {
        return this.metric;
    }

    public Distance add(Distance other) {
        Assert.notNull(other, "Distance to add must not be null!");
        double newNormalizedValue = this.getNormalizedValue() + other.getNormalizedValue();
        return new Distance(newNormalizedValue * this.metric.getMultiplier(), this.metric);
    }

    public Distance add(Distance other, Metric metric) {
        Assert.notNull(other, "Distance to must not be null!");
        Assert.notNull(metric, "Result metric must not be null!");
        double newLeft = this.getNormalizedValue() * metric.getMultiplier();
        double newRight = other.getNormalizedValue() * metric.getMultiplier();
        return new Distance(newLeft + newRight, metric);
    }

    public Distance in(Metric metric) {
        Assert.notNull(metric, "Metric must not be null!");
        return this.metric.equals(metric) ? this : new Distance(this.getNormalizedValue() * metric.getMultiplier(), metric);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Distance)) {
            return false;
        }
        Distance that = (Distance)obj;
        return this.value == that.value && this.metric.equals(that.metric);
    }

    public int hashCode() {
        int result = 17;
        result = (int)((long)result + 31L * Double.doubleToLongBits(this.value));
        return result += 31 * this.metric.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value);
        if (this.metric != Metrics.NEUTRAL) {
            builder.append(" ").append(this.metric.toString());
        }
        return builder.toString();
    }
}

