/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.mysema.query.dml.DeleteClause;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAUpdateClause;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.path.PathBuilder;
import com.mysema.query.types.path.PathBuilderFactory;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.data.jpa.repository.support.Querydsl;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public abstract class QueryDslRepositorySupport {
    private final PathBuilder<?> builder;
    private EntityManager entityManager;
    private Querydsl querydsl;

    public QueryDslRepositorySupport(Class<?> domainClass) {
        Assert.notNull(domainClass);
        this.builder = new PathBuilderFactory().create(domainClass);
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        Assert.notNull(entityManager);
        this.querydsl = new Querydsl(entityManager, this.builder);
        this.entityManager = entityManager;
    }

    @PostConstruct
    public void validate() {
        Assert.notNull(this.entityManager, "EntityManager must not be null!");
        Assert.notNull(this.querydsl, "Querydsl must not be null!");
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected JPQLQuery from(EntityPath<?> ... paths) {
        return this.querydsl.createQuery(paths);
    }

    protected DeleteClause<JPADeleteClause> delete(EntityPath<?> path) {
        return new JPADeleteClause(this.entityManager, path);
    }

    protected UpdateClause<JPAUpdateClause> update(EntityPath<?> path) {
        return new JPAUpdateClause(this.entityManager, path);
    }

    protected <T> PathBuilder<T> getBuilder() {
        return this.builder;
    }

    protected Querydsl getQuerydsl() {
        return this.querydsl;
    }
}

