/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;

public class BeanDefinitionUtils {
    public static Iterable<String> getEntityManagerFactoryBeanNames(ListableBeanFactory beanFactory) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, EntityManagerFactory.class, true, false)));
        for (String factoryBeanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, AbstractEntityManagerFactoryBean.class, true, false)) {
            names.add(BeanFactoryUtils.transformedBeanName(factoryBeanName));
        }
        return names;
    }

    public static Collection<EntityManagerFactoryBeanDefinition> getEntityManagerFactoryBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        ArrayList<EntityManagerFactoryBeanDefinition> definitions = new ArrayList<EntityManagerFactoryBeanDefinition>();
        for (Class type : Arrays.asList(EntityManagerFactory.class, AbstractEntityManagerFactoryBean.class)) {
            for (String name : beanFactory.getBeanNamesForType(type, true, false)) {
                String transformedName = BeanFactoryUtils.transformedBeanName(name);
                EntityManagerFactoryBeanDefinition definition = new EntityManagerFactoryBeanDefinition();
                definition.beanName = transformedName;
                definition.beanFactory = beanFactory;
                definition.beanDefinition = beanFactory.getBeanDefinition(transformedName);
                definitions.add(definition);
            }
        }
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
            definitions.addAll(BeanDefinitionUtils.getEntityManagerFactoryBeanDefinitions((ConfigurableListableBeanFactory)parentBeanFactory));
        }
        return definitions;
    }

    public static BeanDefinition getBeanDefinition(String name, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(name);
        }
        catch (NoSuchBeanDefinitionException o_O) {
            BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
            if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                return BeanDefinitionUtils.getBeanDefinition(name, (ConfigurableListableBeanFactory)parentBeanFactory);
            }
            throw o_O;
        }
    }

    public static class EntityManagerFactoryBeanDefinition {
        public String beanName;
        public BeanDefinition beanDefinition;
        public BeanFactory beanFactory;
    }
}

