/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.RepositoryDefinition;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.Eager;

public abstract class CdiRepositoryExtensionSupport
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdiRepositoryExtensionSupport.class);
    private final Map<Class<?>, Set<Annotation>> repositoryTypes = new HashMap();
    private final Set<CdiRepositoryBean<?>> eagerRepositories = new HashSet();

    protected <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Class repositoryType = annotatedType.getJavaClass();
        if (this.isRepository(repositoryType)) {
            Set<Annotation> qualifiers = this.getQualifiers(repositoryType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Discovered repository type '%s' with qualifiers %s.", repositoryType.getName(), qualifiers));
            }
            this.repositoryTypes.put(repositoryType, qualifiers);
        }
    }

    private boolean isRepository(Class<?> type) {
        boolean isInterface = type.isInterface();
        boolean extendsRepository = Repository.class.isAssignableFrom(type);
        boolean isAnnotated = type.isAnnotationPresent(RepositoryDefinition.class);
        boolean excludedByAnnotation = type.isAnnotationPresent(NoRepositoryBean.class);
        return isInterface && (extendsRepository || isAnnotated) && !excludedByAnnotation;
    }

    private Set<Annotation> getQualifiers(Class<?> type) {
        Annotation[] annotations;
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : annotations = type.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(Qualifier.class)) continue;
            qualifiers.add(annotation);
        }
        if (qualifiers.isEmpty()) {
            qualifiers.add((Annotation)((Object)DefaultAnnotationLiteral.INSTANCE));
        }
        qualifiers.add((Annotation)((Object)AnyAnnotationLiteral.INSTANCE));
        return qualifiers;
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        for (CdiRepositoryBean<?> bean : this.eagerRepositories) {
            LOGGER.debug("Eagerly instantiating CDI repository bean for {}.", (Object)bean.getBeanClass());
            bean.initialize();
        }
    }

    protected Iterable<Map.Entry<Class<?>, Set<Annotation>>> getRepositoryTypes() {
        return this.repositoryTypes.entrySet();
    }

    protected void registerBean(CdiRepositoryBean<?> bean) {
        Class<?> repositoryInterface = bean.getBeanClass();
        if (AnnotationUtils.findAnnotation(repositoryInterface, Eager.class) != null) {
            this.eagerRepositories.add(bean);
        }
    }

    static class AnyAnnotationLiteral
    extends AnnotationLiteral<Any>
    implements Any {
        private static final long serialVersionUID = 7261821376671361463L;
        private static final AnyAnnotationLiteral INSTANCE = new AnyAnnotationLiteral();

        AnyAnnotationLiteral() {
        }
    }

    static class DefaultAnnotationLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 511359421048623933L;
        private static final DefaultAnnotationLiteral INSTANCE = new DefaultAnnotationLiteral();

        DefaultAnnotationLiteral() {
        }
    }
}

