/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;

public abstract class RepositoryFactoryBeanSupport<T extends Repository<S, ID>, S, ID extends Serializable>
implements InitializingBean,
RepositoryFactoryInformation<S, ID>,
FactoryBean<T>,
BeanClassLoaderAware {
    private RepositoryFactorySupport factory;
    private QueryLookupStrategy.Key queryLookupStrategyKey;
    private Class<? extends T> repositoryInterface;
    private Object customImplementation;
    private NamedQueries namedQueries;
    private MappingContext<?, ?> mappingContext;
    private ClassLoader classLoader;
    private boolean lazyInit = false;
    private T repository;
    private RepositoryMetadata repositoryMetadata;

    @Required
    public void setRepositoryInterface(Class<? extends T> repositoryInterface) {
        Assert.notNull(repositoryInterface);
        this.repositoryInterface = repositoryInterface;
    }

    public void setQueryLookupStrategyKey(QueryLookupStrategy.Key queryLookupStrategyKey) {
        this.queryLookupStrategyKey = queryLookupStrategyKey;
    }

    public void setCustomImplementation(Object customImplementation) {
        this.customImplementation = customImplementation;
    }

    public void setNamedQueries(NamedQueries namedQueries) {
        this.namedQueries = namedQueries;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public void setLazyInit(boolean lazy) {
        this.lazyInit = lazy;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public EntityInformation<S, ID> getEntityInformation() {
        return this.factory.getEntityInformation(this.repositoryMetadata.getDomainType());
    }

    @Override
    public RepositoryInformation getRepositoryInformation() {
        return this.factory.getRepositoryInformation(this.repositoryMetadata, this.customImplementation == null ? null : this.customImplementation.getClass());
    }

    @Override
    public PersistentEntity<?, ?> getPersistentEntity() {
        if (this.mappingContext == null) {
            return null;
        }
        return this.mappingContext.getPersistentEntity(this.repositoryMetadata.getDomainType());
    }

    @Override
    public List<QueryMethod> getQueryMethods() {
        return this.factory.getQueryMethods();
    }

    @Override
    public T getObject() {
        return this.initAndReturn();
    }

    @Override
    public Class<? extends T> getObjectType() {
        return null == this.repositoryInterface ? Repository.class : this.repositoryInterface;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull(this.repositoryInterface, "Repository interface must not be null on initialization!");
        this.factory = this.createRepositoryFactory();
        this.factory.setQueryLookupStrategyKey(this.queryLookupStrategyKey);
        this.factory.setNamedQueries(this.namedQueries);
        this.factory.setBeanClassLoader(this.classLoader);
        this.repositoryMetadata = this.factory.getRepositoryMetadata(this.repositoryInterface);
        if (!this.lazyInit) {
            this.initAndReturn();
        }
    }

    private T initAndReturn() {
        Assert.notNull(this.repositoryInterface, "Repository interface must not be null on initialization!");
        if (this.repository == null) {
            this.repository = (Repository)this.factory.getRepository(this.repositoryInterface, this.customImplementation);
        }
        return this.repository;
    }

    protected abstract RepositoryFactorySupport createRepositoryFactory();
}

