/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import org.springframework.data.repository.core.CrudInvoker;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class ReflectionRepositoryInvoker<T>
implements CrudInvoker<T> {
    private final Object repository;
    private final CrudMethods methods;

    public ReflectionRepositoryInvoker(Object repository, CrudMethods methods) {
        Assert.notNull(repository, "Repository must not be null!");
        Assert.notNull(methods, "CrudMethods must not be null!");
        Class<?> type = repository.getClass();
        Assert.isTrue(methods.hasFindOneMethod(), String.format("Repository %s does not expose a findOne(\u2026) method!", type));
        Assert.isTrue(methods.hasSaveMethod(), String.format("Repository %s does not expose a save(\u2026) method!", type));
        this.repository = repository;
        this.methods = methods;
    }

    @Override
    public T invokeSave(T object) {
        return (T)ReflectionUtils.invokeMethod(this.methods.getSaveMethod(), this.repository, object);
    }

    @Override
    public T invokeFindOne(Serializable id) {
        return (T)ReflectionUtils.invokeMethod(this.methods.getFindOneMethod(), this.repository, id);
    }
}

