/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.util.ClassUtils;

public class AnnotatedTypeScanner {
    private final Iterable<Class<? extends Annotation>> annotationTypess;
    private final boolean considerInterfaces;

    public AnnotatedTypeScanner(Class<? extends Annotation> ... annotationTypes) {
        this(true, annotationTypes);
    }

    public AnnotatedTypeScanner(boolean considerInterfaces, Class<? extends Annotation> ... annotationTypes) {
        this.annotationTypess = Arrays.asList(annotationTypes);
        this.considerInterfaces = considerInterfaces;
    }

    public Set<Class<?>> findTypes(String ... basePackages) {
        return this.findTypes(Arrays.asList(basePackages));
    }

    public Set<Class<?>> findTypes(Iterable<String> basePackages) {
        InterfaceAwareScanner provider = new InterfaceAwareScanner(this.considerInterfaces);
        for (Class<? extends Annotation> annotationType : this.annotationTypess) {
            provider.addIncludeFilter(new AnnotationTypeFilter(annotationType, true, this.considerInterfaces));
        }
        HashSet types = new HashSet();
        for (String basePackage : basePackages) {
            for (BeanDefinition definition : provider.findCandidateComponents(basePackage)) {
                try {
                    types.add(ClassUtils.forName(definition.getBeanClassName(), this.getClass().getClassLoader()));
                }
                catch (ClassNotFoundException o_O) {
                    throw new IllegalStateException(o_O);
                }
            }
        }
        return types;
    }

    private static class InterfaceAwareScanner
    extends ClassPathScanningCandidateComponentProvider {
        private final boolean considerInterfaces;

        public InterfaceAwareScanner(boolean considerInterfaces) {
            super(false);
            this.considerInterfaces = considerInterfaces;
        }

        @Override
        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return super.isCandidateComponent(beanDefinition) || this.considerInterfaces && beanDefinition.getMetadata().isInterface();
        }
    }
}

