/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.ExpressionUtils;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public abstract class SpelNodeImpl
implements SpelNode {
    private static SpelNodeImpl[] NO_CHILDREN = new SpelNodeImpl[0];
    protected int pos;
    protected SpelNodeImpl[] children = NO_CHILDREN;
    private SpelNodeImpl parent;

    public SpelNodeImpl(int pos, SpelNodeImpl ... operands) {
        this.pos = pos;
        Assert.isTrue(pos != 0);
        if (operands != null && operands.length > 0) {
            this.children = operands;
            for (SpelNodeImpl childnode : operands) {
                childnode.parent = this;
            }
        }
    }

    protected SpelNodeImpl getPreviousChild() {
        SpelNodeImpl result = null;
        if (this.parent != null) {
            for (SpelNodeImpl child : this.parent.children) {
                if (this == child) break;
                result = child;
            }
        }
        return result;
    }

    protected boolean nextChildIs(Class<?> ... clazzes) {
        if (this.parent != null) {
            SpelNodeImpl[] peers = this.parent.children;
            int max = peers.length;
            for (int i = 0; i < max; ++i) {
                if (peers[i] != this) continue;
                if (i + 1 >= max) {
                    return false;
                }
                Class<?> clazz = peers[i + 1].getClass();
                for (Class<?> desiredClazz : clazzes) {
                    if (!clazz.equals(desiredClazz)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public final Object getValue(ExpressionState expressionState) throws EvaluationException {
        if (expressionState != null) {
            return this.getValueInternal(expressionState).getValue();
        }
        return this.getValue(new ExpressionState(new StandardEvaluationContext()));
    }

    @Override
    public final TypedValue getTypedValue(ExpressionState expressionState) throws EvaluationException {
        if (expressionState != null) {
            return this.getValueInternal(expressionState);
        }
        return this.getTypedValue(new ExpressionState(new StandardEvaluationContext()));
    }

    @Override
    public boolean isWritable(ExpressionState expressionState) throws EvaluationException {
        return false;
    }

    @Override
    public void setValue(ExpressionState expressionState, Object newValue) throws EvaluationException {
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.SETVALUE_NOT_SUPPORTED, this.getClass());
    }

    @Override
    public SpelNode getChild(int index) {
        return this.children[index];
    }

    @Override
    public int getChildCount() {
        return this.children.length;
    }

    @Override
    public Class<?> getObjectClass(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj instanceof Class ? (Class<?>)obj : obj.getClass();
    }

    protected final <T> T getValue(ExpressionState state, Class<T> desiredReturnType) throws EvaluationException {
        return ExpressionUtils.convertTypedValue(state.getEvaluationContext(), this.getValueInternal(state), desiredReturnType);
    }

    @Override
    public int getStartPosition() {
        return this.pos >> 16;
    }

    @Override
    public int getEndPosition() {
        return this.pos & 0xFFFF;
    }

    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        throw new SpelEvaluationException(this.pos, SpelMessage.NOT_ASSIGNABLE, this.toStringAST());
    }

    public abstract TypedValue getValueInternal(ExpressionState var1) throws EvaluationException;
}

