/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4.support;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptorAdapter;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;

public class AsyncRequestInterceptor
extends CallableProcessingInterceptorAdapter
implements DeferredResultProcessingInterceptor {
    private static Log logger = LogFactory.getLog(AsyncRequestInterceptor.class);
    private final SessionFactory sessionFactory;
    private final SessionHolder sessionHolder;
    private volatile boolean timeoutInProgress;

    public AsyncRequestInterceptor(SessionFactory sessionFactory, SessionHolder sessionHolder) {
        this.sessionFactory = sessionFactory;
        this.sessionHolder = sessionHolder;
    }

    public <T> void preProcess(NativeWebRequest request, Callable<T> task) {
        this.bindSession();
    }

    public void bindSession() {
        this.timeoutInProgress = false;
        TransactionSynchronizationManager.bindResource(this.sessionFactory, this.sessionHolder);
    }

    public <T> void postProcess(NativeWebRequest request, Callable<T> task, Object concurrentResult) {
        TransactionSynchronizationManager.unbindResource(this.sessionFactory);
    }

    public <T> Object handleTimeout(NativeWebRequest request, Callable<T> task) {
        this.timeoutInProgress = true;
        return RESULT_NONE;
    }

    public <T> void afterCompletion(NativeWebRequest request, Callable<T> task) throws Exception {
        this.closeAfterTimeout();
    }

    private void closeAfterTimeout() {
        if (this.timeoutInProgress) {
            logger.debug("Closing Hibernate Session after async request timeout");
            SessionFactoryUtils.closeSession(this.sessionHolder.getSession());
        }
    }

    public <T> void beforeConcurrentHandling(NativeWebRequest request, DeferredResult<T> deferredResult) {
    }

    public <T> void preProcess(NativeWebRequest request, DeferredResult<T> deferredResult) {
    }

    public <T> void postProcess(NativeWebRequest request, DeferredResult<T> deferredResult, Object result) {
    }

    public <T> boolean handleTimeout(NativeWebRequest request, DeferredResult<T> deferredResult) {
        this.timeoutInProgress = true;
        return true;
    }

    public <T> void afterCompletion(NativeWebRequest request, DeferredResult<T> deferredResult) {
        this.closeAfterTimeout();
    }
}

