/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import javax.servlet.http.HttpServletRequest;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.web.util.ELRequestMatcherContext;
import org.springframework.security.web.util.RequestMatcher;

public class ELRequestMatcher
implements RequestMatcher {
    private final Expression expression;

    public ELRequestMatcher(String el) {
        SpelExpressionParser parser = new SpelExpressionParser();
        this.expression = parser.parseExpression(el);
    }

    public boolean matches(HttpServletRequest request) {
        EvaluationContext context = this.createELContext(request);
        return this.expression.getValue(context, Boolean.class);
    }

    public EvaluationContext createELContext(HttpServletRequest request) {
        return new StandardEvaluationContext(new ELRequestMatcherContext(request));
    }
}

