/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public abstract class Command {
    private Options options = this.createOptions();
    private String command;

    public Command(String command) {
        this.command = command;
    }

    protected abstract Options createOptions();

    public String getCommandName() {
        return this.command;
    }

    public void execute(String[] args) {
        try {
            PosixParser parser = new PosixParser();
            CommandLine cl = parser.parse(this.options, args);
            this.executeImpl(args, cl);
        }
        catch (ParseException ex) {
            this.usage(args);
        }
    }

    protected abstract void executeImpl(String[] var1, CommandLine var2);

    protected void usage(String[] args) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("content-index-tool " + args[0] + " [options] ", this.options);
        System.exit(1);
    }
}

